#ifndef Processor_h
#include "Processor.h"
#endif

using namespace doctorj;

Processor::Processor()
{
}

Processor::~Processor()
{
}

void Processor::traverse(AstNode* const n)
{
    list<AstItem*>::iterator start = n->components().begin();
    list<AstItem*>::iterator stop = n->components().end();
    for (list<AstItem*>::iterator it = start; it != stop; ++it) {
        AstItem* component = *it;
        component->getProcessed(this);
    }
}

void Processor::traverse(AstItem* const i)
{
    // items don't traverse
}

void Processor::traverse(AstLeaf* const l)
{
    // leaves don't traverse
}

void Processor::process(AstAbstract* const a)
{
    traverse(a);
}

void Processor::process(AstAbstractMethodDeclaration* const amd)
{
    traverse(amd);
}

void Processor::process(AstAdditiveExpression* const ae)
{
    traverse(ae);
}

void Processor::process(AstAdditiveExpressionMinus* const aem)
{
    traverse(aem);
}

void Processor::process(AstAdditiveExpressionPlus* const aep)
{
    traverse(aep);
}

void Processor::process(AstAnd* const a)
{
    traverse(a);
}

void Processor::process(AstAndExpression* const ae)
{
    traverse(ae);
}

void Processor::process(AstAndand* const a)
{
    traverse(a);
}

void Processor::process(AstAndeq* const a)
{
    traverse(a);
}

void Processor::process(AstArrayAccess* const aa)
{
    traverse(aa);
}

void Processor::process(AstArrayAccessName* const aan)
{
    traverse(aan);
}

void Processor::process(AstArrayAccessPrimary* const aap)
{
    traverse(aap);
}

void Processor::process(AstArrayCreationExpression* const ace)
{
    traverse(ace);
}

void Processor::process(AstArrayCreationExpressionNameDimsInit* const acendi)
{
    traverse(acendi);
}

void Processor::process(AstArrayCreationExpressionNameExprDims* const acened)
{
    traverse(acened);
}

void Processor::process(AstArrayCreationExpressionNameExprNoDims* const acenend)
{
    traverse(acenend);
}

void Processor::process(AstArrayCreationExpressionPrimitiveDimsInit* const acepdi)
{
    traverse(acepdi);
}

void Processor::process(AstArrayCreationExpressionPrimitiveExprDims* const aceped)
{
    traverse(aceped);
}

void Processor::process(AstArrayCreationExpressionPrimitiveExprNoDims* const acepend)
{
    traverse(acepend);
}

void Processor::process(AstArrayInitializer* const ai)
{
    traverse(ai);
}

void Processor::process(AstArrayInitializerComma* const aic)
{
    traverse(aic);
}

void Processor::process(AstArrayInitializerEmpty* const aie)
{
    traverse(aie);
}

void Processor::process(AstArrayInitializerVars* const aiv)
{
    traverse(aiv);
}

void Processor::process(AstArrayInitializerVarsComma* const aivc)
{
    traverse(aivc);
}

void Processor::process(AstArrayNameType* const ant)
{
    traverse(ant);
}

void Processor::process(AstArrayPrimitiveType* const apt)
{
    traverse(apt);
}

void Processor::process(AstArrayType* const at)
{
    traverse(at);
}

void Processor::process(AstArrayTypeDotClass* const atdc)
{
    traverse(atdc);
}

void Processor::process(AstAssert* const a)
{
    traverse(a);
}

void Processor::process(AstAssertStatement* const a)
{
    traverse(a);
}

void Processor::process(AstAssertStatementOneExpression* const as)
{
    traverse(as);
}

void Processor::process(AstAssertStatementTwoExpressions* const as)
{
    traverse(as);
}

void Processor::process(AstAssignment* const a)
{
    traverse(a);
}

void Processor::process(AstAssignmentArray* const aa)
{
    traverse(aa);
}

void Processor::process(AstAssignmentField* const af)
{
    traverse(af);
}

void Processor::process(AstAssignmentName* const an)
{
    traverse(an);
}

void Processor::process(AstAssignmentOperator* const ao)
{
    traverse(ao);
}

void Processor::process(AstBlock* const b)
{
    traverse(b);
}

void Processor::process(AstBlockNoStatements* const bns)
{
    traverse(bns);
}

void Processor::process(AstBlockStatementList* const bsl)
{
    traverse(bsl);
}

void Processor::process(AstBlockWStatements* const bWs)
{
    traverse(bWs);
}

void Processor::process(AstBoolean* const b)
{
    traverse(b);
}

void Processor::process(AstBooleanLiteral* const bl)
{
    traverse(bl);
}

void Processor::process(AstBreak* const b)
{
    traverse(b);
}

void Processor::process(AstBreakStatement* const bs)
{
    traverse(bs);
}

void Processor::process(AstBreakStatementId* const bsi)
{
    traverse(bsi);
}

void Processor::process(AstBreakStatementNoId* const bsni)
{
    traverse(bsni);
}

void Processor::process(AstByte* const b)
{
    traverse(b);
}

void Processor::process(AstCComment* const Cc)
{
    traverse(Cc);
}

void Processor::process(AstCase* const c)
{
    traverse(c);
}

void Processor::process(AstCastExpression* const ce)
{
    traverse(ce);
}

void Processor::process(AstCastExpressionExpr* const cee)
{
    traverse(cee);
}

void Processor::process(AstCastExpressionNameDims* const cend)
{
    traverse(cend);
}

void Processor::process(AstCastExpressionPrimitiveDims* const cepd)
{
    traverse(cepd);
}

void Processor::process(AstCastExpressionPrimitiveNoDims* const cepnd)
{
    traverse(cepnd);
}

void Processor::process(AstCatch* const c)
{
    traverse(c);
}

void Processor::process(AstCatchClause* const cc)
{
    traverse(cc);
}

void Processor::process(AstCatchClauseList* const ccl)
{
    traverse(ccl);
}

void Processor::process(AstChar* const c)
{
    traverse(c);
}

void Processor::process(AstCharacterLiteral* const cl)
{
    traverse(cl);
}

void Processor::process(AstClass* const c)
{
    traverse(c);
}

void Processor::process(AstClassBody* const cb)
{
    traverse(cb);
}

void Processor::process(AstClassBodyDeclarationList* const cbdl)
{
    traverse(cbdl);
}

void Processor::process(AstClassBodyDecls* const cbd)
{
    traverse(cbd);
}

void Processor::process(AstClassBodyEmpty* const cbe)
{
    traverse(cbe);
}

void Processor::process(AstClassDeclaration* const cd)
{
    traverse(cd);
}

void Processor::process(AstClassDeclarationModsBaseless* const cdmb)
{
    traverse(cdmb);
}

void Processor::process(AstClassDeclarationModsExtends* const cdme)
{
    traverse(cdme);
}

void Processor::process(AstClassDeclarationModsExtendsImplements* const cdmei)
{
    traverse(cdmei);
}

void Processor::process(AstClassDeclarationModsImplements* const cdmi)
{
    traverse(cdmi);
}

void Processor::process(AstClassDeclarationNoModsBaseless* const cdnmb)
{
    traverse(cdnmb);
}

void Processor::process(AstClassDeclarationNoModsExtends* const cdnme)
{
    traverse(cdnme);
}

void Processor::process(AstClassDeclarationNoModsExtendsImplements* const cdnmei)
{
    traverse(cdnmei);
}

void Processor::process(AstClassDeclarationNoModsImplements* const cdnmi)
{
    traverse(cdnmi);
}

void Processor::process(AstClassInstanceCreationExpression* const cice)
{
    traverse(cice);
}

void Processor::process(AstClassInstanceCreationExpressionNameExprBody* const ciceneb)
{
    traverse(ciceneb);
}

void Processor::process(AstClassInstanceCreationExpressionNameExprNoBody* const cicenenb)
{
    traverse(cicenenb);
}

void Processor::process(AstClassInstanceCreationExpressionNameIdExprBody* const cicenieb)
{
    traverse(cicenieb);
}

void Processor::process(AstClassInstanceCreationExpressionNameIdExprNoBody* const cicenienb)
{
    traverse(cicenienb);
}

void Processor::process(AstClassInstanceCreationExpressionNameIdNoExprBody* const cicenineb)
{
    traverse(cicenineb);
}

void Processor::process(AstClassInstanceCreationExpressionNameIdNoExprNoBody* const ciceninenb)
{
    traverse(ciceninenb);
}

void Processor::process(AstClassInstanceCreationExpressionNameNoExprBody* const cicenneb)
{
    traverse(cicenneb);
}

void Processor::process(AstClassInstanceCreationExpressionNameNoExprNoBody* const cicennenb)
{
    traverse(cicennenb);
}

void Processor::process(AstClassInstanceCreationExpressionPrimaryExprBody* const cicepeb)
{
    traverse(cicepeb);
}

void Processor::process(AstClassInstanceCreationExpressionPrimaryExprNoBody* const cicepenb)
{
    traverse(cicepenb);
}

void Processor::process(AstClassInstanceCreationExpressionPrimaryNoExprBody* const cicepneb)
{
    traverse(cicepneb);
}

void Processor::process(AstClassInstanceCreationExpressionPrimaryNoExprNoBody* const cicepnenb)
{
    traverse(cicepnenb);
}

void Processor::process(AstClassMemberDeclaration* const cmd)
{
    traverse(cmd);
}

void Processor::process(AstClassMemberDeclarationModsExtendsImplements* const cmdmei)
{
    traverse(cmdmei);
}

void Processor::process(AstClassMemberDeclarationModsExtendsNoImplements* const cmdmeni)
{
    traverse(cmdmeni);
}

void Processor::process(AstClassMemberDeclarationModsNoExtendsImplements* const cmdmnei)
{
    traverse(cmdmnei);
}

void Processor::process(AstClassMemberDeclarationModsNoExtendsNoImplements* const cmdmneni)
{
    traverse(cmdmneni);
}

void Processor::process(AstClassMemberDeclarationNoModsExtendsImplements* const cmdnmei)
{
    traverse(cmdnmei);
}

void Processor::process(AstClassMemberDeclarationNoModsExtendsNoImplements* const cmdnmeni)
{
    traverse(cmdnmeni);
}

void Processor::process(AstClassMemberDeclarationNoModsNoExtendsImplements* const cmdnmnei)
{
    traverse(cmdnmnei);
}

void Processor::process(AstClassMemberDeclarationNoModsNoExtendsNoImplements* const cmdnmneni)
{
    traverse(cmdnmneni);
}

void Processor::process(AstColon* const c)
{
    traverse(c);
}

void Processor::process(AstComma* const c)
{
    traverse(c);
}

void Processor::process(AstComment* const c)
{
    traverse(c);
}

void Processor::process(AstComp* const c)
{
    traverse(c);
}

void Processor::process(AstCompilationUnit* const cu)
{
    traverse(cu);
}

void Processor::process(AstCompilationUnitEmpty* const cue)
{
    traverse(cue);
}

void Processor::process(AstCompilationUnitImp* const cui)
{
    traverse(cui);
}

void Processor::process(AstCompilationUnitImpTypes* const cuit)
{
    traverse(cuit);
}

void Processor::process(AstCompilationUnitPkg* const cup)
{
    traverse(cup);
}

void Processor::process(AstCompilationUnitPkgImp* const cupi)
{
    traverse(cupi);
}

void Processor::process(AstCompilationUnitPkgImpTypes* const cupit)
{
    traverse(cupit);
}

void Processor::process(AstCompilationUnitPkgTypes* const cupt)
{
    traverse(cupt);
}

void Processor::process(AstCompilationUnitTypes* const cut)
{
    traverse(cut);
}

void Processor::process(AstConditionalAndExpression* const cae)
{
    traverse(cae);
}

void Processor::process(AstConditionalArithExpression* const cae)
{
    traverse(cae);
}

void Processor::process(AstConditionalOrExpression* const coe)
{
    traverse(coe);
}

void Processor::process(AstConst* const c)
{
    traverse(c);
}

void Processor::process(AstConstructorBody* const cb)
{
    traverse(cb);
}

void Processor::process(AstConstructorBodyBlock* const cbb)
{
    traverse(cbb);
}

void Processor::process(AstConstructorBodyEmpty* const cbe)
{
    traverse(cbe);
}

void Processor::process(AstConstructorBodyExplicit* const cbe)
{
    traverse(cbe);
}

void Processor::process(AstConstructorBodyExplicitBlock* const cbeb)
{
    traverse(cbeb);
}

void Processor::process(AstConstructorDeclaration* const cd)
{
    traverse(cd);
}

void Processor::process(AstConstructorDeclarationModsNoThrows* const cdmnt)
{
    traverse(cdmnt);
}

void Processor::process(AstConstructorDeclarationModsThrows* const cdmt)
{
    traverse(cdmt);
}

void Processor::process(AstConstructorDeclarationNoModsNoThrows* const cdnmnt)
{
    traverse(cdnmnt);
}

void Processor::process(AstConstructorDeclarationNoModsThrows* const cdnmt)
{
    traverse(cdnmt);
}

void Processor::process(AstConstructorDeclarator* const cd)
{
    traverse(cd);
}

void Processor::process(AstConstructorDeclaratorEmpty* const cde)
{
    traverse(cde);
}

void Processor::process(AstConstructorDeclaratorParams* const cdp)
{
    traverse(cdp);
}

void Processor::process(AstContinue* const c)
{
    traverse(c);
}

void Processor::process(AstContinueStatement* const cs)
{
    traverse(cs);
}

void Processor::process(AstContinueStatementId* const csi)
{
    traverse(csi);
}

void Processor::process(AstContinueStatementNoId* const csni)
{
    traverse(csni);
}

void Processor::process(AstCppComment* const cc)
{
    traverse(cc);
}

void Processor::process(AstDefault* const d)
{
    traverse(d);
}

void Processor::process(AstDimension* const d)
{
    traverse(d);
}

void Processor::process(AstDimensionExpression* const de)
{
    traverse(de);
}

void Processor::process(AstDimensionExpressionList* const del)
{
    traverse(del);
}

void Processor::process(AstDimensionList* const dl)
{
    traverse(dl);
}

void Processor::process(AstDiv* const d)
{
    traverse(d);
}

void Processor::process(AstDiveq* const d)
{
    traverse(d);
}

void Processor::process(AstDo* const d)
{
    traverse(d);
}

void Processor::process(AstDoStatement* const ds)
{
    traverse(ds);
}

void Processor::process(AstDot* const d)
{
    traverse(d);
}

void Processor::process(AstDouble* const d)
{
    traverse(d);
}

void Processor::process(AstElse* const e)
{
    traverse(e);
}

void Processor::process(AstEq* const e)
{
    traverse(e);
}

void Processor::process(AstEqeq* const e)
{
    traverse(e);
}

void Processor::process(AstEqualityExpression* const ee)
{
    traverse(ee);
}

void Processor::process(AstEqualityExpressionEq* const eee)
{
    traverse(eee);
}

void Processor::process(AstEqualityExpressionNe* const een)
{
    traverse(een);
}

void Processor::process(AstExplicitConstructorInvocation* const eci)
{
    traverse(eci);
}

void Processor::process(AstExplicitConstructorInvocationPrimarySuper* const ecips)
{
    traverse(ecips);
}

void Processor::process(AstExplicitConstructorInvocationPrimarySuperExpressions* const ecipse)
{
    traverse(ecipse);
}

void Processor::process(AstExplicitConstructorInvocationPrimaryThis* const ecipt)
{
    traverse(ecipt);
}

void Processor::process(AstExplicitConstructorInvocationPrimaryThisExpressions* const ecipte)
{
    traverse(ecipte);
}

void Processor::process(AstExplicitConstructorInvocationSuper* const ecis)
{
    traverse(ecis);
}

void Processor::process(AstExplicitConstructorInvocationSuperExpressions* const ecise)
{
    traverse(ecise);
}

void Processor::process(AstExplicitConstructorInvocationThis* const ecit)
{
    traverse(ecit);
}

void Processor::process(AstExplicitConstructorInvocationThisExpressions* const ecite)
{
    traverse(ecite);
}

void Processor::process(AstExpressionList* const el)
{
    traverse(el);
}

void Processor::process(AstExpressionStatement* const es)
{
    traverse(es);
}

void Processor::process(AstExtends* const e)
{
    traverse(e);
}

void Processor::process(AstExtendsInterfaceList* const eil)
{
    traverse(eil);
}

void Processor::process(AstFalseLiteral* const fl)
{
    traverse(fl);
}

void Processor::process(AstFieldAccess* const fa)
{
    traverse(fa);
}

void Processor::process(AstFieldAccessNameSuper* const fans)
{
    traverse(fans);
}

void Processor::process(AstFieldAccessPrimary* const fap)
{
    traverse(fap);
}

void Processor::process(AstFieldAccessSuper* const fas)
{
    traverse(fas);
}

void Processor::process(AstFieldDeclaration* const fd)
{
    traverse(fd);
}

void Processor::process(AstFieldDeclarationMods* const fdm)
{
    traverse(fdm);
}

void Processor::process(AstFieldDeclarationNoMods* const fdnm)
{
    traverse(fdnm);
}

void Processor::process(AstFinal* const f)
{
    traverse(f);
}

void Processor::process(AstFinally* const f)
{
    traverse(f);
}

void Processor::process(AstFinallyBlock* const fb)
{
    traverse(fb);
}

void Processor::process(AstFloat* const f)
{
    traverse(f);
}

void Processor::process(AstFloatingPointLiteral* const fpl)
{
    traverse(fpl);
}

void Processor::process(AstFloatingPointType* const fpt)
{
    traverse(fpt);
}

void Processor::process(AstFor* const f)
{
    traverse(f);
}

void Processor::process(AstForStatement* const fs)
{
    traverse(fs);
}

void Processor::process(AstForStatementNoInitConditionNoUpdate* const fsnicnu)
{
    traverse(fsnicnu);
}

void Processor::process(AstForStatementNoInitConditionUpdate* const fsnicu)
{
    traverse(fsnicu);
}

void Processor::process(AstForStatementNoInitNoConditionNoUpdate* const fsnincnu)
{
    traverse(fsnincnu);
}

void Processor::process(AstForStatementNoInitNoConditionUpdate* const fsnincu)
{
    traverse(fsnincu);
}

void Processor::process(AstForStatementStmtsConditionNoUpdate* const fsscnu)
{
    traverse(fsscnu);
}

void Processor::process(AstForStatementStmtsConditionUpdate* const fsscu)
{
    traverse(fsscu);
}

void Processor::process(AstForStatementStmtsNoConditionNoUpdate* const fssncnu)
{
    traverse(fssncnu);
}

void Processor::process(AstForStatementStmtsNoConditionUpdate* const fssncu)
{
    traverse(fssncu);
}

void Processor::process(AstForStatementVarsConditionNoUpdate* const fsvcnu)
{
    traverse(fsvcnu);
}

void Processor::process(AstForStatementVarsConditionUpdate* const fsvcu)
{
    traverse(fsvcu);
}

void Processor::process(AstForStatementVarsNoConditionNoUpdate* const fsvncnu)
{
    traverse(fsvncnu);
}

void Processor::process(AstForStatementVarsNoConditionUpdate* const fsvncu)
{
    traverse(fsvncu);
}

void Processor::process(AstFormalParameter* const fp)
{
    traverse(fp);
}

void Processor::process(AstFormalParameterFinal* const fpf)
{
    traverse(fpf);
}

void Processor::process(AstFormalParameterList* const fpl)
{
    traverse(fpl);
}

void Processor::process(AstFormalParameterNonFinal* const fpnf)
{
    traverse(fpnf);
}

void Processor::process(AstGoto* const g)
{
    traverse(g);
}

void Processor::process(AstGt* const g)
{
    traverse(g);
}

void Processor::process(AstGteq* const g)
{
    traverse(g);
}

void Processor::process(AstIdentifier* const i)
{
    traverse(i);
}

void Processor::process(AstIf* const i)
{
    traverse(i);
}

void Processor::process(AstIfThenElseStatement* const ites)
{
    traverse(ites);
}

void Processor::process(AstIfThenStatement* const its)
{
    traverse(its);
}

void Processor::process(AstImplements* const i)
{
    traverse(i);
}

void Processor::process(AstImplementsInterfaceList* const iil)
{
    traverse(iil);
}

void Processor::process(AstImport* const i)
{
    traverse(i);
}

void Processor::process(AstImportDeclaration* const id)
{
    traverse(id);
}

void Processor::process(AstImportDeclarationList* const idl)
{
    traverse(idl);
}

void Processor::process(AstImportDeclarationOnDemand* const idod)
{
    traverse(idod);
}

void Processor::process(AstImportDeclarationSingle* const ids)
{
    traverse(ids);
}

void Processor::process(AstInstanceof* const i)
{
    traverse(i);
}

void Processor::process(AstInt* const i)
{
    traverse(i);
}

void Processor::process(AstIntegerLiteral* const il)
{
    traverse(il);
}

void Processor::process(AstIntegralType* const it)
{
    traverse(it);
}

void Processor::process(AstInterface* const i)
{
    traverse(i);
}

void Processor::process(AstInterfaceBody* const ib)
{
    traverse(ib);
}

void Processor::process(AstInterfaceBodyDecls* const ibd)
{
    traverse(ibd);
}

void Processor::process(AstInterfaceBodyNoDecls* const ibnd)
{
    traverse(ibnd);
}

void Processor::process(AstInterfaceDeclaration* const id)
{
    traverse(id);
}

void Processor::process(AstInterfaceDeclarationModsExtends* const idme)
{
    traverse(idme);
}

void Processor::process(AstInterfaceDeclarationModsNoExtends* const idmne)
{
    traverse(idmne);
}

void Processor::process(AstInterfaceDeclarationNoModsExtends* const idnme)
{
    traverse(idnme);
}

void Processor::process(AstInterfaceDeclarationNoModsNoExtends* const idnmne)
{
    traverse(idnmne);
}

void Processor::process(AstInterfaceMemberDeclarationList* const imdl)
{
    traverse(imdl);
}

void Processor::process(AstJavadocComment* const jc)
{
    traverse(jc);
}

void Processor::process(AstLabeledStatement* const ls)
{
    traverse(ls);
}

void Processor::process(AstLbrace* const l)
{
    traverse(l);
}

void Processor::process(AstLbracket* const l)
{
    traverse(l);
}

void Processor::process(AstLiteral* const l)
{
    traverse(l);
}

void Processor::process(AstLocalVariableDeclaration* const lvd)
{
    traverse(lvd);
}

void Processor::process(AstLocalVariableDeclarationFinal* const lvdf)
{
    traverse(lvdf);
}

void Processor::process(AstLocalVariableDeclarationNonFinal* const lvdnf)
{
    traverse(lvdnf);
}

void Processor::process(AstLocalVariableDeclarationStatement* const lvds)
{
    traverse(lvds);
}

void Processor::process(AstLong* const l)
{
    traverse(l);
}

void Processor::process(AstLparen* const l)
{
    traverse(l);
}

void Processor::process(AstLshift* const l)
{
    traverse(l);
}

void Processor::process(AstLshifteq* const l)
{
    traverse(l);
}

void Processor::process(AstLt* const l)
{
    traverse(l);
}

void Processor::process(AstLteq* const l)
{
    traverse(l);
}

void Processor::process(AstMethodDeclaration* const md)
{
    traverse(md);
}

void Processor::process(AstMethodDeclarationBlock* const mdb)
{
    traverse(mdb);
}

void Processor::process(AstMethodDeclarationSemicolon* const mds)
{
    traverse(mds);
}

void Processor::process(AstMethodDeclarator* const md)
{
    traverse(md);
}

void Processor::process(AstMethodDeclaratorNoArgs* const mdna)
{
    traverse(mdna);
}

void Processor::process(AstMethodDeclaratorWArgs* const mdWa)
{
    traverse(mdWa);
}

void Processor::process(AstMethodHeader* const mh)
{
    traverse(mh);
}

void Processor::process(AstMethodHeaderTypeModsNoThrows* const mhtmnt)
{
    traverse(mhtmnt);
}

void Processor::process(AstMethodHeaderTypeModsThrows* const mhtmt)
{
    traverse(mhtmt);
}

void Processor::process(AstMethodHeaderTypeNoModsNoThrows* const mhtnmnt)
{
    traverse(mhtnmnt);
}

void Processor::process(AstMethodHeaderTypeNoModsThrows* const mhtnmt)
{
    traverse(mhtnmt);
}

void Processor::process(AstMethodHeaderVoidModsNoThrows* const mhvmnt)
{
    traverse(mhvmnt);
}

void Processor::process(AstMethodHeaderVoidModsThrows* const mhvmt)
{
    traverse(mhvmt);
}

void Processor::process(AstMethodHeaderVoidNoModsNoThrows* const mhvnmnt)
{
    traverse(mhvnmnt);
}

void Processor::process(AstMethodHeaderVoidNoModsThrows* const mhvnmt)
{
    traverse(mhvnmt);
}

void Processor::process(AstMethodInvocation* const mi)
{
    traverse(mi);
}

void Processor::process(AstMethodInvocationNameArgs* const mina)
{
    traverse(mina);
}

void Processor::process(AstMethodInvocationNameNoArgs* const minna)
{
    traverse(minna);
}

void Processor::process(AstMethodInvocationNameSuperArgs* const minsa)
{
    traverse(minsa);
}

void Processor::process(AstMethodInvocationNameSuperNoArgs* const minsna)
{
    traverse(minsna);
}

void Processor::process(AstMethodInvocationPrimaryArgs* const mipa)
{
    traverse(mipa);
}

void Processor::process(AstMethodInvocationPrimaryNoArgs* const mipna)
{
    traverse(mipna);
}

void Processor::process(AstMethodInvocationSuperArgs* const misa)
{
    traverse(misa);
}

void Processor::process(AstMethodInvocationSuperNoArgs* const misna)
{
    traverse(misna);
}

void Processor::process(AstMinus* const m)
{
    traverse(m);
}

void Processor::process(AstMinuseq* const m)
{
    traverse(m);
}

void Processor::process(AstMinusminus* const m)
{
    traverse(m);
}

void Processor::process(AstMod* const m)
{
    traverse(m);
}

void Processor::process(AstModeq* const m)
{
    traverse(m);
}

void Processor::process(AstModifierList* const ml)
{
    traverse(ml);
}

void Processor::process(AstMult* const m)
{
    traverse(m);
}

void Processor::process(AstMulteq* const m)
{
    traverse(m);
}

void Processor::process(AstMultiplicativeExpression* const me)
{
    traverse(me);
}

void Processor::process(AstMultiplicativeExpressionDiv* const med)
{
    traverse(med);
}

void Processor::process(AstMultiplicativeExpressionMod* const mem)
{
    traverse(mem);
}

void Processor::process(AstMultiplicativeExpressionMult* const mem)
{
    traverse(mem);
}

void Processor::process(AstName* const n)
{
    traverse(n);
}

void Processor::process(AstNameDotClass* const ndc)
{
    traverse(ndc);
}

void Processor::process(AstNameDotThis* const ndt)
{
    traverse(ndt);
}

void Processor::process(AstNameList* const nl)
{
    traverse(nl);
}

void Processor::process(AstNative* const n)
{
    traverse(n);
}

void Processor::process(AstNew* const n)
{
    traverse(n);
}

void Processor::process(AstNoncode* const n)
{
    traverse(n);
}

void Processor::process(AstNot* const n)
{
    traverse(n);
}

void Processor::process(AstNoteq* const n)
{
    traverse(n);
}

void Processor::process(AstNullLiteral* const nl)
{
    traverse(nl);
}

void Processor::process(AstNumericType* const nt)
{
    traverse(nt);
}

void Processor::process(AstOr* const o)
{
    traverse(o);
}

void Processor::process(AstOrExpression* const oe)
{
    traverse(oe);
}

void Processor::process(AstOreq* const o)
{
    traverse(o);
}

void Processor::process(AstOror* const o)
{
    traverse(o);
}

void Processor::process(AstPackage* const p)
{
    traverse(p);
}

void Processor::process(AstPackageDeclaration* const pd)
{
    traverse(pd);
}

void Processor::process(AstPlus* const p)
{
    traverse(p);
}

void Processor::process(AstPluseq* const p)
{
    traverse(p);
}

void Processor::process(AstPlusplus* const p)
{
    traverse(p);
}

void Processor::process(AstPostdecrementExpression* const pe)
{
    traverse(pe);
}

void Processor::process(AstPostincrementExpression* const pe)
{
    traverse(pe);
}

void Processor::process(AstPredecrementExpression* const pe)
{
    traverse(pe);
}

void Processor::process(AstPreincrementExpression* const pe)
{
    traverse(pe);
}

void Processor::process(AstPrimaryParenExpression* const ppe)
{
    traverse(ppe);
}

void Processor::process(AstPrimitiveDotClass* const pdc)
{
    traverse(pdc);
}

void Processor::process(AstPrimitiveType* const pt)
{
    traverse(pt);
}

void Processor::process(AstPrivate* const p)
{
    traverse(p);
}

void Processor::process(AstProject* const p)
{
    traverse(p);
}

void Processor::process(AstProtected* const p)
{
    traverse(p);
}

void Processor::process(AstPublic* const p)
{
    traverse(p);
}

void Processor::process(AstQuestion* const q)
{
    traverse(q);
}

void Processor::process(AstRbrace* const r)
{
    traverse(r);
}

void Processor::process(AstRbracket* const r)
{
    traverse(r);
}

void Processor::process(AstRelationalExpression* const re)
{
    traverse(re);
}

void Processor::process(AstRelationalExpressionGt* const reg)
{
    traverse(reg);
}

void Processor::process(AstRelationalExpressionGteq* const reg)
{
    traverse(reg);
}

void Processor::process(AstRelationalExpressionInstanceof* const rei)
{
    traverse(rei);
}

void Processor::process(AstRelationalExpressionLt* const rel)
{
    traverse(rel);
}

void Processor::process(AstRelationalExpressionLteq* const rel)
{
    traverse(rel);
}

void Processor::process(AstReturn* const r)
{
    traverse(r);
}

void Processor::process(AstReturnStatement* const rs)
{
    traverse(rs);
}

void Processor::process(AstReturnStatementEmpty* const rse)
{
    traverse(rse);
}

void Processor::process(AstReturnStatementExpr* const rse)
{
    traverse(rse);
}

void Processor::process(AstRparen* const r)
{
    traverse(r);
}

void Processor::process(AstRshift* const r)
{
    traverse(r);
}

void Processor::process(AstRshifteq* const r)
{
    traverse(r);
}

void Processor::process(AstSemicolon* const s)
{
    traverse(s);
}

void Processor::process(AstShiftExpression* const se)
{
    traverse(se);
}

void Processor::process(AstShiftExpressionLshift* const sel)
{
    traverse(sel);
}

void Processor::process(AstShiftExpressionRshift* const ser)
{
    traverse(ser);
}

void Processor::process(AstShiftExpressionUrshift* const seu)
{
    traverse(seu);
}

void Processor::process(AstShort* const s)
{
    traverse(s);
}

void Processor::process(AstStatementExpressionList* const sel)
{
    traverse(sel);
}

void Processor::process(AstStatic* const s)
{
    traverse(s);
}

void Processor::process(AstStaticInitializer* const si)
{
    traverse(si);
}

void Processor::process(AstStrictfp* const s)
{
    traverse(s);
}

void Processor::process(AstStringLeaf* const sl)
{
    traverse(sl);
}

void Processor::process(AstStringLiteral* const sl)
{
    traverse(sl);
}

void Processor::process(AstSuper* const s)
{
    traverse(s);
}

void Processor::process(AstSwitch* const s)
{
    traverse(s);
}

void Processor::process(AstSwitchBlock* const sb)
{
    traverse(sb);
}

void Processor::process(AstSwitchBlockEmpty* const sbe)
{
    traverse(sbe);
}

void Processor::process(AstSwitchBlockGroups* const sbg)
{
    traverse(sbg);
}

void Processor::process(AstSwitchBlockGroupsLabels* const sbgl)
{
    traverse(sbgl);
}

void Processor::process(AstSwitchBlockLabels* const sbl)
{
    traverse(sbl);
}

void Processor::process(AstSwitchBlockStatementGroup* const sbsg)
{
    traverse(sbsg);
}

void Processor::process(AstSwitchBlockStatementGroupList* const sbsgl)
{
    traverse(sbsgl);
}

void Processor::process(AstSwitchLabel* const sl)
{
    traverse(sl);
}

void Processor::process(AstSwitchLabelCase* const slc)
{
    traverse(slc);
}

void Processor::process(AstSwitchLabelDefault* const sld)
{
    traverse(sld);
}

void Processor::process(AstSwitchLabelList* const sll)
{
    traverse(sll);
}

void Processor::process(AstSwitchStatement* const ss)
{
    traverse(ss);
}

void Processor::process(AstSynchronized* const s)
{
    traverse(s);
}

void Processor::process(AstSynchronizedStatement* const ss)
{
    traverse(ss);
}

void Processor::process(AstTaggedComment* const tc)
{
    traverse(tc);
}

void Processor::process(AstTaggedDescribedComment* const tdc)
{
    traverse(tdc);
}

void Processor::process(AstThis* const t)
{
    traverse(t);
}

void Processor::process(AstThrow* const t)
{
    traverse(t);
}

void Processor::process(AstThrowStatement* const ts)
{
    traverse(ts);
}

void Processor::process(AstThrows* const t)
{
    traverse(t);
}

void Processor::process(AstThrowsNameList* const tnl)
{
    traverse(tnl);
}

void Processor::process(AstTransient* const t)
{
    traverse(t);
}

void Processor::process(AstTrueLiteral* const tl)
{
    traverse(tl);
}

void Processor::process(AstTry* const t)
{
    traverse(t);
}

void Processor::process(AstTryStatement* const ts)
{
    traverse(ts);
}

void Processor::process(AstTryStatementCatches* const tsc)
{
    traverse(tsc);
}

void Processor::process(AstTryStatementCatchesFinally* const tscf)
{
    traverse(tscf);
}

void Processor::process(AstTryStatementFinally* const tsf)
{
    traverse(tsf);
}

void Processor::process(AstTypeDeclarationList* const tdl)
{
    traverse(tdl);
}

void Processor::process(AstUnaryExpression* const ue)
{
    traverse(ue);
}

void Processor::process(AstUnaryExpressionComp* const uec)
{
    traverse(uec);
}

void Processor::process(AstUnaryExpressionMinus* const uem)
{
    traverse(uem);
}

void Processor::process(AstUnaryExpressionNot* const uen)
{
    traverse(uen);
}

void Processor::process(AstUnaryExpressionPlus* const uep)
{
    traverse(uep);
}

void Processor::process(AstUrshift* const u)
{
    traverse(u);
}

void Processor::process(AstUrshifteq* const u)
{
    traverse(u);
}

void Processor::process(AstValue* const v)
{
    traverse(v);
}

void Processor::process(AstVariableDeclarator* const vd)
{
    traverse(vd);
}

void Processor::process(AstVariableDeclaratorAssign* const vda)
{
    traverse(vda);
}

void Processor::process(AstVariableDeclaratorId* const vdi)
{
    traverse(vdi);
}

void Processor::process(AstVariableDeclaratorIdDimensions* const vdid)
{
    traverse(vdid);
}

void Processor::process(AstVariableDeclaratorIdNoDimensions* const vdind)
{
    traverse(vdind);
}

void Processor::process(AstVariableDeclaratorList* const vdl)
{
    traverse(vdl);
}

void Processor::process(AstVariableDeclaratorNoAssign* const vdna)
{
    traverse(vdna);
}

void Processor::process(AstVariableInitializerList* const vil)
{
    traverse(vil);
}

void Processor::process(AstVoid* const v)
{
    traverse(v);
}

void Processor::process(AstVoidDotClass* const vdc)
{
    traverse(vdc);
}

void Processor::process(AstVolatile* const v)
{
    traverse(v);
}

void Processor::process(AstWhile* const w)
{
    traverse(w);
}

void Processor::process(AstWhileStatement* const ws)
{
    traverse(ws);
}

void Processor::process(AstXor* const x)
{
    traverse(x);
}

void Processor::process(AstXorExpression* const xe)
{
    traverse(xe);
}

void Processor::process(AstXoreq* const x)
{
    traverse(x);
}
