#ifndef Test_h
#include "Test.h"
#endif

#ifndef Java_h
#include "Java.h"
#endif

#ifndef Log_h
#include "Log.h"
#endif

#ifndef std_fstream
#define std_fstream
#include <fstream>
#endif

using namespace doctorj;

static void spew(const string& name, AstItem* const item, int indent = 0)
{
    while (--indent >= 0) {
        cout << "    ";
    }
    cout << name << " = " << item->type() << " (" << item->text() << ")" << endl;
}

class JavaSymbolLocalVariableTest : public Test 
{
public:
    JavaSymbolLocalVariableTest() : Test(true) 
    {
        Log::setEnabled();
    }
    virtual void run();
};

void JavaSymbolLocalVariableTest::run() 
{
    // write out a file
    string cname("JSymTestLocalVariable");
    string fname("/tmp/" + cname + ".java");
    ofstream of(fname.c_str());
    of << "public class " << cname << " {" << endl;
    of << "    public " << cname << "(int a) {" << endl;
    of << "        int i = 4;" << endl;
    of << "        i += 3;" << endl;
    of << "    }" << endl;
    of << "}" << endl;
    of.close();

    vector<char*> unused;
    unused.push_back(const_cast<char*>(fname.c_str()));
    AstProject project(1.3, unused);

    AstCompilationUnit* cu = project.getCompilationUnit(0);
    AstTypeDeclarationList* types = cu->getTypeDeclarationList();

    AstItem* type = types->getTypeDeclaration(0);
    spew("type", type);

    AstClassDeclaration* cd = dynamic_cast<AstClassDeclaration*>(type);
    spew("class declaration", cd);

    AstClassBody* classbody = cd->getClassBody();
    spew("class body", classbody);

    AstClassBodyDeclarationList* contents = classbody->getClassBodyDeclarationList();
    spew("class contents", contents);

    AstItem* decl = contents->getClassBodyDeclaration(0);
    spew("decl", decl);

    AstConstructorDeclaration* ctor = dynamic_cast<AstConstructorDeclaration*>(decl);
    spew("ctor", ctor, 1);

    AstConstructorBody* ctorbody = ctor->getConstructorBody();
    spew("ctor body", ctorbody, 2);

    AstBlockStatementList* statements = ctorbody->getBlockStatementList();
    spew("ctor statements", statements, 3);

    AstItem* stitem = statements->getBlockStatement(0);

    AstLocalVariableDeclarationStatement* lvdstmt = dynamic_cast<AstLocalVariableDeclarationStatement*>(stitem);
    spew("local var decl stmt", lvdstmt, 4);

    AstLocalVariableDeclaration* lvardec = lvdstmt->getLocalVariableDeclaration();
    spew("local var decl", lvardec, 5);
    
    AstVariableDeclaratorList* varlist = lvardec->getVariableDeclaratorList();

    AstVariableDeclarator* vardec = varlist->getVariableDeclarator(0);

    AstExpressionStatement* exprst = dynamic_cast<AstExpressionStatement*>(statements->getBlockStatement(1));
    spew("expr st", exprst, 6);

    AstItem* expr = exprst->getExpression();
    spew("expr", expr, 7);
    
    AstAssignmentName* assname = dynamic_cast<AstAssignmentName*>(expr);
    spew("ass name", assname, 8);

    AstName* name = assname->getName();
    spew("name", name, 9);
    
    AstItem* declaration = JavaSymbol::findVariableDeclaration(name);
    TEST(declaration != NULL, "declaration is not NULL");
    TESTEQ(declaration, lvardec, "declaration is the variable declaration");
}

int main(int argc, char** argv) 
{
    JavaSymbolLocalVariableTest t;
    t.run();
    cout << "symbol local variable lookup test results: " << t << endl;
    return t.nerrors();
}
