#ifndef Test_h
#include "Test.h"
#endif

#ifndef DebugOptions_h
#include "DebugOptions.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef std_iostream
#define std_iostream
#include <iostream>
#endif

#ifndef string_h
#include "string.h"
#endif

using namespace std;
using namespace doctorj;

REGISTER_DEBUG_OPTION('P', "Javadoc parser");

class AstJavadocCommentTest : public Test
{
public:
    AstJavadocCommentTest() : Test(true) {}
    virtual void run();
};

void AstJavadocCommentTest::run()
{
    {
        char* cmt =
            "/**\n"
            "     * @param o\n"
            "     */\n";

        cout << "comment = '" << cmt << "'" << endl;
        AstJavadocComment jc(cmt, cmt + strlen(cmt), NULL);
        AstTaggedComment* tc = jc.taggedComments()[0];
        TEST(tc != NULL, "has one tagged comment");

        AstTaggedDescribedComment* tdc = dynamic_cast<AstTaggedDescribedComment*>(tc);
        TEST(tdc != NULL, "has one tagged described comment");

        TEST(tdc->tagStart() != NULL, "has a tag start");
        TEST(tdc->tagEnd() != NULL, "has a tag end");
        TEST(tdc->descriptionStart() != NULL, "has a description start");
        TEST(tdc->descriptionEnd() != NULL, "has a description end");
        TEST(tdc->targetStart() != NULL, "has a target start");
        TEST(tdc->targetEnd() != NULL, "has a target end");

        cout << "tag start: " << (void*)tdc->tagStart() << endl;
        cout << "tag end: " << (void*)tdc->tagEnd() << endl;
        cout << "description start: " << (void*)tdc->descriptionStart() << endl;
        cout << "description end: " << (void*)tdc->descriptionEnd() << endl;
        cout << "target start: " << (void*)tdc->targetStart() << endl;
        cout << "target end: " << (void*)tdc->targetEnd() << endl;
        
//         JavadocParser p(cmt, cmt + strlen(cmt));

//         vector<TagCmt> tags;
//         p.getTagCmts(&tags);
//         TESTEQ(tags.size(), 1, "number of tags");

//         TESTEQ(string(tags[0].start,     tags[0].end     - tags[0].start     + 1), "@param", "value of first tag");
//         TESTEQ(string(tags[0].descStart, tags[0].descEnd - tags[0].descStart + 1), "x",      "description of first tag");
    }

}

int main(int argc, char** argv)
{
    AstJavadocCommentTest t;
    t.run();
    cout << "JavadocComment test results: " << t << endl;
    return t.nerrors();
}
