#ifndef Test_h
#include "Test.h"
#endif

#ifndef DebugOptions_h
#include "DebugOptions.h"
#endif

#ifndef JavadocParser_h
#include "JavadocParser.h"
#endif

#ifndef std_iostream
#define std_iostream
#include <iostream>
#endif

#ifndef string_h
#include "string.h"
#endif

using namespace std;
using namespace doctorj;

REGISTER_DEBUG_OPTION('P', "Javadoc parser");

class JavadocParserTest : public Test
{
public:
    JavadocParserTest() : Test(true) {}
    virtual void run();
};

void JavadocParserTest::run()
{
    {
        char* cmt =
            "/**\n"
            " * A desc.\n"
            " * Second line.\n"
            " * Third.\n"
            " * @t1 E.\n"
            " */\n";

        cout << "comment = '" << cmt << "'" << endl;
        JavadocParser p(cmt, cmt + strlen(cmt));
        char* ds;
        char* de;
        p.getDescription(&ds, &de);
        TESTEQ(string(ds, de - ds + 1), "A desc.\n * Second line.\n * Third.", "description");
        vector<TagCmt> tags;
        p.getTagCmts(&tags);
        TESTEQ(tags.size(), 1, "number of tags");
        TESTEQ(string(tags[0].start, tags[0].end - tags[0].start + 1), "@t1", "tag value");
        TESTEQ(string(tags[0].descStart, tags[0].descEnd - tags[0].descStart + 1), "E.", "tag description value");
    }

    {
        char* cmt =
            "/**\n"
            " * This has a description.\n"
            " * @t1 E.\n"
            " * @t2\n"
            " */\n";

        cout << "comment = '" << cmt << "'" << endl;
        JavadocParser p(cmt, cmt + strlen(cmt));
        char* ds;
        char* de;
        p.getDescription(&ds, &de);
        TESTEQ(string(ds, de - ds + 1), "This has a description.", "description");
        vector<TagCmt> tags;
        p.getTagCmts(&tags);
        TESTEQ(tags.size(), 2, "number of tags");
        TESTEQ(string(tags[0].start,     tags[0].end     - tags[0].start     + 1), "@t1", "value of first tag");
        TESTEQ(string(tags[0].descStart, tags[0].descEnd - tags[0].descStart + 1), "E.",  "description of first tag");

        TESTEQ(string(tags[1].start,     tags[1].end     - tags[1].start     + 1), "@t2", "value of second tag");
        TEST(tags[1].descStart == NULL, "description (none) of second tag");
        TEST(tags[1].descEnd == NULL, "description (none) of second tag");
    }

    {
        char* cmt =
            "/**\n"
            " * @t1 @bad description\n"
            " * @t1a    \n"
            " * @t2 X.\n"
            " */\n";

        cout << "comment = '" << cmt << "'" << endl;
        JavadocParser p(cmt, cmt + strlen(cmt));

        char* ds;
        char* de;
        p.getDescription(&ds, &de);
        TEST(ds == NULL, "description (none)");
        TEST(de == NULL, "description (none)");
        vector<TagCmt> tags;
        p.getTagCmts(&tags);
        TESTEQ(tags.size(), 3, "number of tags");

        TESTEQ(string(tags[0].start,     tags[0].end     - tags[0].start     + 1), "@t1", "value of first tag");
        TESTEQ(string(tags[0].descStart, tags[0].descEnd - tags[0].descStart + 1), "@bad description", "description of first tag");

        TESTEQ(string(tags[1].start,     tags[1].end     - tags[1].start     + 1), "@t1a", "value of second tag");
        TEST(tags[1].descStart == NULL, "description (none) of second tag");
        TEST(tags[1].descEnd == NULL, "description (none) of second tag");

        TESTEQ(string(tags[2].start,     tags[2].end     - tags[2].start     + 1), "@t2", "value of third tag");
        TESTEQ(string(tags[2].descStart, tags[2].descEnd - tags[2].descStart + 1), "X.", "description of third tag");
    }

    {
        char* cmt =
            "/**\n"
            " * \n"
            " */\n";

        cout << "comment = '" << cmt << "'" << endl;
        JavadocParser p(cmt, cmt + strlen(cmt));

        char* ds;
        char* de;
        p.getDescription(&ds, &de);
        TEST(ds == NULL, "description (none)");
        TEST(de == NULL, "description (none)");
        vector<TagCmt> tags;
        p.getTagCmts(&tags);
        TESTEQ(tags.size(), 0, "number of tags (none)");
    }

    {
        char* cmt =
            "/**\n"
            " * @param x\n"
            " */\n";

        cout << "comment = '" << cmt << "'" << endl;
        JavadocParser p(cmt, cmt + strlen(cmt));

        vector<TagCmt> tags;
        p.getTagCmts(&tags);
        TESTEQ(tags.size(), 1, "number of tags");

        TESTEQ(string(tags[0].start,     tags[0].end     - tags[0].start     + 1), "@param", "value of first tag");
        TESTEQ(string(tags[0].descStart, tags[0].descEnd - tags[0].descStart + 1), "x",      "description of first tag");
    }

}

int main(int argc, char** argv)
{
    JavadocParserTest t;
    t.run();
    cout << "JavadocParser test results: " << t << endl;
    return t.nerrors();
}
