#ifndef InnerTypeStatistics_h
#include "InnerTypeStatistics.h"
#endif

#ifndef ConcreteClassStatistics_h
#include "ConcreteClassStatistics.h"
#endif

#ifndef AbstractClassStatistics_h
#include "AbstractClassStatistics.h"
#endif

#ifndef InterfaceStatistics_h
#include "InterfaceStatistics.h"
#endif

using namespace doctorj;

InnerTypeStatistics::InnerTypeStatistics(const string& name, int nLines) :
        Statistics(name, nLines),
     nStaticMethods_(0),
     nInstanceMethods_(0),
     nStaticFields_(0),
     nInstanceFields_(0)
{
}

InnerTypeStatistics::~InnerTypeStatistics()
{
    vector<InnerTypeStatistics*>::iterator it   = containedTypes_.begin();
    vector<InnerTypeStatistics*>::iterator stop = containedTypes_.end();
    while (it != stop) {
        InnerTypeStatistics* cts = *it;
        delete cts;
        ++it;
    }
}

void InnerTypeStatistics::addStaticMethod(int nLines)
{
    ++nStaticMethods_;
    methods_.push_back(nLines);
}

void InnerTypeStatistics::addInstanceMethod(int nLines)
{
    ++nInstanceMethods_;
    methods_.push_back(nLines);
}

void InnerTypeStatistics::addStaticField()
{
    ++nStaticFields_;
}

void InnerTypeStatistics::addInstanceField()
{
    ++nInstanceFields_;
}

void InnerTypeStatistics::addStaticFields(int count)
{
    nStaticFields_ += count;
}

void InnerTypeStatistics::addInstanceFields(int count)
{
    nInstanceFields_ += count;
}

int InnerTypeStatistics::getStaticMethodsCount() const
{
    return nStaticMethods_;
}

int InnerTypeStatistics::getInstanceMethodsCount() const
{
    return nInstanceMethods_;
}

int InnerTypeStatistics::getStaticFieldsCount() const
{
    return nStaticFields_;
}

int InnerTypeStatistics::getInstanceFieldsCount() const
{
    return nInstanceFields_;
}

vector<int> InnerTypeStatistics::getMethods() const
{
    return methods_;
}

const vector<InnerTypeStatistics*>& InnerTypeStatistics::innerTypes() const
{
    return containedTypes_;
}

void InnerTypeStatistics::addInnerType(InnerTypeStatistics* const cts)
{
    containedTypes_.push_back(cts);
}

template <class Type>
static int count(const vector<InnerTypeStatistics*>& vec)
{
    vector<InnerTypeStatistics*>::const_iterator it   = vec.begin();
    vector<InnerTypeStatistics*>::const_iterator stop = vec.end();
    int num = 0;
    while (it != stop) {
        InnerTypeStatistics* ts = *it;
        if (dynamic_cast<Type>(ts)) {
            ++num;
        }
        ++it;
    }
    return num;
}

int InnerTypeStatistics::getConcreteClassesCount() const
{
    return count<ConcreteClassStatistics*>(containedTypes_);
}

int InnerTypeStatistics::getAbstractClassesCount() const
{
    return count<AbstractClassStatistics*>(containedTypes_);
}

int InnerTypeStatistics::getInterfacesCount() const
{
    return count<InterfaceStatistics*>(containedTypes_);
}
