#ifndef StatisticsGroup_h
#define StatisticsGroup_h

#include <vector>
#include <math.h>

using namespace std;

namespace doctorj
{
    template <typename T>
    class StatisticsGroup
    {
    public:
        StatisticsGroup();

        virtual ~StatisticsGroup();

        int count() const;

        double mean() const;

        T sum() const;

        double variance() const;

        double pseudoVariance() const;

        T min() const;

        T max() const;

        int mindex() const;

        int maxdex() const;

        double standardDeviation() const;

        T sampleRange() const;
    
        void addData(T v);

    private:

        /**
         * Specifies whether we have received any data.
         */
        bool gotData_;

        int count_;

        double mean_;

        T sum_;

        double variance_;

        double pseudoVariance_;

        T min_;

        T max_;

        int mindex_;

        int maxdex_;

        double standardDeviation_;

        T sampleRange_;
    
    };

    template <typename T>
    StatisticsGroup<T>::StatisticsGroup() :
            gotData_(false), 
         count_(0),
         mean_(0),
         sum_(0),
         variance_(0),
         pseudoVariance_(0),
         min_(0),
         max_(0),
         mindex_(0),
         maxdex_(0),
         standardDeviation_(0),
         sampleRange_(0)
    {
    }

    template <typename T>
    StatisticsGroup<T>::~StatisticsGroup()
    {
    }

    template <typename T>
    int StatisticsGroup<T>::count() const
    {
        return count_;
    }

    template <typename T>
    double StatisticsGroup<T>::mean() const
    {
        return mean_;
    }

    template <typename T>
    T StatisticsGroup<T>::sum() const
    {
        return sum_;
    }

    template <typename T>
    double StatisticsGroup<T>::variance() const
    {
        return variance_;
    }

    template <typename T>
    double StatisticsGroup<T>::pseudoVariance() const
    {
        return pseudoVariance_;
    }

    template <typename T>
    T StatisticsGroup<T>::min() const
    {
        return min_;
    }

    template <typename T>
    T StatisticsGroup<T>::max() const
    {
        return max_;
    }

    template <typename T>
    int StatisticsGroup<T>::mindex() const
    {
        return mindex_;
    }

    template <typename T>
    int StatisticsGroup<T>::maxdex() const
    {
        return maxdex_;
    }

    template <typename T>
    double StatisticsGroup<T>::standardDeviation() const
    {
        return standardDeviation_;
    }

    template <typename T>
    T StatisticsGroup<T>::sampleRange() const
    {
        return sampleRange_;
    }

    template <typename T>
    void StatisticsGroup<T>::addData(T v)
    {
        T   min    = gotData_ ? min_    : v;
        T   max    = gotData_ ? max_    : v;
        int mindex = gotData_ ? mindex_ : 0;
        int maxdex = gotData_ ? maxdex_ : 0;
    
        double oldmean = mean_;
        sum_ += v;
        ++count_;
        
        if (v >= max) {
            max    = v;
            maxdex = count_ - 1;
        }
        if (v <= min) {
            min    = v;
            mindex = count_ - 1;
        }

        mean_           += (v - oldmean) / (T)count_;
        pseudoVariance_ += (v - oldmean) * (v - mean_);

        min_          = min;
        mindex_       = mindex;
        max_          = max;
        maxdex_       = maxdex;
        sampleRange_  = max_ - min_;

        if (count_ > 1) {
            variance_          = pseudoVariance_ / (count_ - 1);
            standardDeviation_ = sqrt(variance_);
        }

        gotData_ = true;
    }
    
}

#endif //! StatisticsGroup_h
