#ifndef StatisticsReporterText_h
#define StatisticsReporterText_h

#ifndef StatisticsReporter_h
#include "StatisticsReporter.h"
#endif

#ifndef Stats_h
#include "Stats.h"
#endif

#ifndef std_vector
#define std_vector
#include <vector>
#endif

using namespace std;

namespace doctorj
{
    class InnerTypeStatistics;
    class ProjectStatistics;
    
    class StatisticsReporterText : public StatisticsReporter
    {
    public:
        
        StatisticsReporterText(ostream& os);

        virtual ~StatisticsReporterText();

        virtual void writeString(const string& label, const string& str);

        virtual void writeFullReport(ProjectStatistics* const ps);

    protected:

        virtual void outputSummary(int nLines,
                                   int nTypes,
                                   int nConcretes,
                                   int nAbstracts,
                                   int nInterfaces,
                                   const vector<int>& typeLines,
                                   int nStaticMethods,
                                   int nInstanceMethods,
                                   const vector<int>& methodLines,
                                   int nStaticFields,
                                   int nInstanceFields);

        virtual void outputInnerType(const string& type, 
                                     const string& name,
                                     const vector<InnerTypeStatistics*>& innerTypes,
                                     int nLines,
                                     int nStaticMethods,
                                     int nInstanceMethods,
                                     const vector<int>& methods,
                                     int nStaticFields,
                                     int nInstanceFields);
        
        template <typename Type>
        void writeStats(const vector<Type>& vec)
        {
            Stats<Type> stats(vec);
            write("lines",   stats.sum());
            incrementLevel();
            write("mean",    stats.mean());
            write("std dev", stats.standardDeviation());
            write("highest", stats.max());
            write("lowest",  stats.min());
            decrementLevel();
        }

    };

}

#endif //! StatisticsReporter_h
