#ifndef ErrorAbstractMethodModifierUsedInInterface_h
#define ErrorAbstractMethodModifierUsedInInterface_h

#ifndef SyntaxError_h
#include "SyntaxError.h"
#endif

namespace doctorj 
{
    class AstAbstractMethodDeclaration;
    class AstInterfaceDeclaration;

    class ErrorAbstractMethodModifierUsedInInterface : public SyntaxError 
    {
    public:
        
        ErrorAbstractMethodModifierUsedInInterface();

        /**
         * Creates the error.
         */
        ErrorAbstractMethodModifierUsedInInterface(Reporter* const reporter, 
                                                   AstAbstractMethodDeclaration* const am,
                                                   AstInterfaceDeclaration* const id);
        
        virtual ~ErrorAbstractMethodModifierUsedInInterface();

        /**
         * Returns the title of this error.
         */
        virtual string title() const;

        /**
         * Writes the long description of this error to the given output stream.
         */
        virtual void writeDescription(ostream& os) const;

        /**
         * Returns the message describing this error. 
         */
        virtual string message() const;

    private:

        string method_;

        string interface_;

    };

}

#endif //! ErrorAbstractMethodModifierUsedInInterface_h
