#ifndef ErrorEmptyStatement_h
#define ErrorEmptyStatement_h

#ifndef SyntaxError_h
#include "SyntaxError.h"
#endif

namespace doctorj 
{
    class ErrorEmptyStatement : public SyntaxError 
    {
    public:
        
        ErrorEmptyStatement();

        /**
         * Creates the error.
         */
        ErrorEmptyStatement(Reporter* const reporter, AstItem* const it);
        
        virtual ~ErrorEmptyStatement();

        /**
         * Returns the title of this error.
         */
        virtual string title() const;

        /**
         * Writes the long description of this error to the given output stream.
         */
        virtual void writeDescription(ostream& os) const;

        /**
         * Returns the message describing this error. 
         */
        virtual string message() const;

        /**
         * The control keyword associated with the statement. This is lowercase.
         */
        virtual string keyword() const = 0;

    };

}

#endif //! ErrorEmptyStatement_h
