#ifndef ErrorExplicitBooleanInConditional_h
#include "ErrorExplicitBooleanInConditional.h"
#endif

#ifndef StringUtilities_h
#include "StringUtilities.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

using namespace doctorj;

ErrorExplicitBooleanInConditional::ErrorExplicitBooleanInConditional()
{
}

ErrorExplicitBooleanInConditional::ErrorExplicitBooleanInConditional(Reporter* const reporter, AstEqualityExpression* const ee) :
        SyntaxError(reporter, ee)
{
}

ErrorExplicitBooleanInConditional::~ErrorExplicitBooleanInConditional()
{
}

string ErrorExplicitBooleanInConditional::title() const
{
    return "Explicit Usage of " + getType() + " in Conditional Expression";
}

void ErrorExplicitBooleanInConditional::writeDescription(ostream& os) const
{
    string lctype = StringUtilities::toLower(getType());
    os << "'" << lctype << "' does not have to be explicitly used in a conditional expression." << endl;
}

string ErrorExplicitBooleanInConditional::message() const
{
    string lctype = StringUtilities::toLower(getType());
    return "'" + lctype + "' explicitly used in a conditional expression";
}
