#ifndef ErrorFieldPackageAccess_h
#define ErrorFieldPackageAccess_h

#ifndef ErrorPackageAccess_h
#include "ErrorPackageAccess.h"
#endif

namespace doctorj 
{
    class AstItem;

    class ErrorFieldPackageAccess : public ErrorPackageAccess 
    {
    public:
        ErrorFieldPackageAccess();

        /**
         * Creates the error for the field.
         */
        ErrorFieldPackageAccess(Reporter* const reporter, AstItem* const item, const string& name);

        virtual ~ErrorFieldPackageAccess();

        /**
         * Returns what type of thing this refers to, in lowercase format.
         */
        virtual string typeAsLowercase() const;

        /**
         * Returns what type of thing this refers to, in capitalized format.
         */
        virtual string typeAsCapitalized() const;
        
    };
}

#endif //! ErrorFieldPackageAccess_h
