#ifndef ErrorGenericExceptionSpecification_h
#define ErrorGenericExceptionSpecification_h

#ifndef SyntaxError_h
#include "SyntaxError.h"
#endif

namespace doctorj 
{
    class AstThrowsNameList;

    class ErrorGenericExceptionSpecification : public SyntaxError 
    {
    public:
        
        ErrorGenericExceptionSpecification();

        /**
         * Creates the error.
         */
        ErrorGenericExceptionSpecification(Reporter* const reporter, AstThrowsNameList* const tnl);

        virtual ~ErrorGenericExceptionSpecification();

        /**
         * Returns the title of this error.
         */
        virtual string title() const;

        /**
         * Writes the long description of this error to the given output stream.
         */
        virtual void writeDescription(ostream& os) const;

        /**
         * Returns the message describing this error. 
         */
        virtual string message() const;

    private:

        AstThrowsNameList* throwsList_;

    };

}

#endif //! ErrorGenericExceptionSpecification_h
