#ifndef ErrorImproperSequence_h
#define ErrorImproperSequence_h

#ifndef SyntaxError_h
#include "SyntaxError.h"
#endif

namespace doctorj 
{
    class ErrorImproperSequence : public SyntaxError 
    {
    public:
        
        ErrorImproperSequence();

        /**
         * Creates the error.
         * 
         * @param item      The item to be highlighted, such as the class name.
         * @param previous  The item that preceded this item.
         * @param current   The current item, such as the class declaration.
         */
        ErrorImproperSequence(Reporter* const reporter, AstItem* const item, AstItem* const previous, AstItem* const current);

        virtual ~ErrorImproperSequence();

        /**
         * Returns the title of this error.
         */
        virtual string title() const;

        /**
         * Writes the long description of this error to the given output stream.
         */
        virtual void writeDescription(ostream& os) const;

        /**
         * Returns the message describing this error. 
         */
        virtual string message() const;

    private:

        /**
         * The previous item.
         */
        AstItem* previous_;

        /**
         * The current item.
         */
        AstItem* const current_;

    };

}

#endif //! ErrorImproperSequence_h
