#ifndef ErrorNameStandard_h
#include "ErrorNameStandard.h"
#endif

#ifndef ErrorRegistry_h
#include "ErrorRegistry.h"
#endif

#include <ctype.h>

using namespace std;
using namespace doctorj;

char doctorj::FIELD_[] = "field";
char doctorj::PACKAGE_[] = "package";
char doctorj::PRIVATE_[] = "private";
char doctorj::PROTECTED_[] = "protected";
char doctorj::PUBLIC_[] = "public";

string doctorj::convert(const string& str, bool toUpper)
{
    string res(str);
    res[0] = toUpper ? toupper(res[0]) : tolower(res[0]);
    return res;
}


REGISTER_DESCRIPTION(ErrorInstanceFinalPackageFieldName);

ErrorInstanceFinalPackageFieldName::ErrorInstanceFinalPackageFieldName()
{
}

ErrorInstanceFinalPackageFieldName::ErrorInstanceFinalPackageFieldName(Reporter* const reporter, 
                                                                       AstItem* const item, 
                                                                       const string& name,
                                                                       const string& standard) :
        ErrorNameStandard<false, true, PACKAGE_, FIELD_>(reporter, item, name, standard)
{
}

ErrorInstanceFinalPackageFieldName::~ErrorInstanceFinalPackageFieldName()
{
}


REGISTER_DESCRIPTION(ErrorInstanceFinalPrivateFieldName);

ErrorInstanceFinalPrivateFieldName::ErrorInstanceFinalPrivateFieldName()
{
}

ErrorInstanceFinalPrivateFieldName::ErrorInstanceFinalPrivateFieldName(Reporter* const reporter, 
                                                                       AstItem* const item, 
                                                                       const string& name,
                                                                       const string& standard) :
        ErrorNameStandard<false, true, PRIVATE_, FIELD_>(reporter, item, name, standard)
{
}

ErrorInstanceFinalPrivateFieldName::~ErrorInstanceFinalPrivateFieldName()
{
}


REGISTER_DESCRIPTION(ErrorInstanceFinalProtectedFieldName);

ErrorInstanceFinalProtectedFieldName::ErrorInstanceFinalProtectedFieldName()
{
}

ErrorInstanceFinalProtectedFieldName::ErrorInstanceFinalProtectedFieldName(Reporter* const reporter, 
                                                                           AstItem* const item, 
                                                                           const string& name,
                                                                           const string& standard) :
        ErrorNameStandard<false, true, PROTECTED_, FIELD_>(reporter, item, name, standard)
{
}

ErrorInstanceFinalProtectedFieldName::~ErrorInstanceFinalProtectedFieldName()
{
}


REGISTER_DESCRIPTION(ErrorInstanceFinalPublicFieldName);

ErrorInstanceFinalPublicFieldName::ErrorInstanceFinalPublicFieldName()
{
}

ErrorInstanceFinalPublicFieldName::ErrorInstanceFinalPublicFieldName(Reporter* const reporter, 
                                                                     AstItem* const item, 
                                                                     const string& name,
                                                                     const string& standard) :
        ErrorNameStandard<false, true, PUBLIC_, FIELD_>(reporter, item, name, standard)
{
}

ErrorInstanceFinalPublicFieldName::~ErrorInstanceFinalPublicFieldName()
{
}


REGISTER_DESCRIPTION(ErrorInstanceNonfinalPackageFieldName);

ErrorInstanceNonfinalPackageFieldName::ErrorInstanceNonfinalPackageFieldName()
{
}

ErrorInstanceNonfinalPackageFieldName::ErrorInstanceNonfinalPackageFieldName(Reporter* const reporter, 
                                                                             AstItem* const item, 
                                                                             const string& name,
                                                                             const string& standard) :
        ErrorNameStandard<false, false, PACKAGE_, FIELD_>(reporter, item, name, standard)
{
}

ErrorInstanceNonfinalPackageFieldName::~ErrorInstanceNonfinalPackageFieldName()
{
}


REGISTER_DESCRIPTION(ErrorInstanceNonfinalPrivateFieldName);

ErrorInstanceNonfinalPrivateFieldName::ErrorInstanceNonfinalPrivateFieldName()
{
}

ErrorInstanceNonfinalPrivateFieldName::ErrorInstanceNonfinalPrivateFieldName(Reporter* const reporter, AstItem* const item, 
                                                                             const string& name,
                                                                             const string& standard) :
        ErrorNameStandard<false, false, PRIVATE_, FIELD_>(reporter, item, name, standard)
{
}

ErrorInstanceNonfinalPrivateFieldName::~ErrorInstanceNonfinalPrivateFieldName()
{
}


REGISTER_DESCRIPTION(ErrorInstanceNonfinalProtectedFieldName);

ErrorInstanceNonfinalProtectedFieldName::ErrorInstanceNonfinalProtectedFieldName()
{
}

ErrorInstanceNonfinalProtectedFieldName::ErrorInstanceNonfinalProtectedFieldName(Reporter* const reporter, AstItem* const item, 
                                                                                 const string& name,
                                                                                 const string& standard) :
        ErrorNameStandard<false, false, PROTECTED_, FIELD_>(reporter, item, name, standard)
{
}

ErrorInstanceNonfinalProtectedFieldName::~ErrorInstanceNonfinalProtectedFieldName()
{
}


REGISTER_DESCRIPTION(ErrorInstanceNonfinalPublicFieldName);

ErrorInstanceNonfinalPublicFieldName::ErrorInstanceNonfinalPublicFieldName()
{
}

ErrorInstanceNonfinalPublicFieldName::ErrorInstanceNonfinalPublicFieldName(Reporter* const reporter, AstItem* const item, 
                                                                           const string& name,
                                                                           const string& standard) :
        ErrorNameStandard<false, false, PUBLIC_, FIELD_>(reporter, item, name, standard)
{
}

ErrorInstanceNonfinalPublicFieldName::~ErrorInstanceNonfinalPublicFieldName()
{
}


REGISTER_DESCRIPTION(ErrorStaticFinalPackageFieldName);

ErrorStaticFinalPackageFieldName::ErrorStaticFinalPackageFieldName()
{
}

ErrorStaticFinalPackageFieldName::ErrorStaticFinalPackageFieldName(Reporter* const reporter, AstItem* const item, 
                                                                   const string& name,
                                                                   const string& standard) :
        ErrorNameStandard<true, true, PACKAGE_, FIELD_>(reporter, item, name, standard)
{
}

ErrorStaticFinalPackageFieldName::~ErrorStaticFinalPackageFieldName()
{
}


REGISTER_DESCRIPTION(ErrorStaticFinalPrivateFieldName);

ErrorStaticFinalPrivateFieldName::ErrorStaticFinalPrivateFieldName()
{
}

ErrorStaticFinalPrivateFieldName::ErrorStaticFinalPrivateFieldName(Reporter* const reporter, AstItem* const item, 
                                                                   const string& name,
                                                                   const string& standard) :
        ErrorNameStandard<true, true, PRIVATE_, FIELD_>(reporter, item, name, standard)
{
}

ErrorStaticFinalPrivateFieldName::~ErrorStaticFinalPrivateFieldName()
{
}


REGISTER_DESCRIPTION(ErrorStaticFinalProtectedFieldName);

ErrorStaticFinalProtectedFieldName::ErrorStaticFinalProtectedFieldName()
{
}

ErrorStaticFinalProtectedFieldName::ErrorStaticFinalProtectedFieldName(Reporter* const reporter, AstItem* const item, 
                                                                       const string& name,
                                                                       const string& standard) :
        ErrorNameStandard<true, true, PROTECTED_, FIELD_>(reporter, item, name, standard)
{
}

ErrorStaticFinalProtectedFieldName::~ErrorStaticFinalProtectedFieldName()
{
}


REGISTER_DESCRIPTION(ErrorStaticFinalPublicFieldName);

ErrorStaticFinalPublicFieldName::ErrorStaticFinalPublicFieldName()
{
}

ErrorStaticFinalPublicFieldName::ErrorStaticFinalPublicFieldName(Reporter* const reporter, AstItem* const item, 
                                                                 const string& name,
                                                                 const string& standard) :
        ErrorNameStandard<true, true, PUBLIC_, FIELD_>(reporter, item, name, standard)
{
}

ErrorStaticFinalPublicFieldName::~ErrorStaticFinalPublicFieldName()
{
}


REGISTER_DESCRIPTION(ErrorStaticNonfinalPackageFieldName);

ErrorStaticNonfinalPackageFieldName::ErrorStaticNonfinalPackageFieldName()
{
}

ErrorStaticNonfinalPackageFieldName::ErrorStaticNonfinalPackageFieldName(Reporter* const reporter, AstItem* const item, 
                                                                         const string& name,
                                                                         const string& standard) :
        ErrorNameStandard<true, false, PACKAGE_, FIELD_>(reporter, item, name, standard)
{
}

ErrorStaticNonfinalPackageFieldName::~ErrorStaticNonfinalPackageFieldName()
{
}


REGISTER_DESCRIPTION(ErrorStaticNonfinalPrivateFieldName);

ErrorStaticNonfinalPrivateFieldName::ErrorStaticNonfinalPrivateFieldName()
{
}

ErrorStaticNonfinalPrivateFieldName::ErrorStaticNonfinalPrivateFieldName(Reporter* const reporter, AstItem* const item, 
                                                                         const string& name,
                                                                         const string& standard) :
        ErrorNameStandard<true, false, PRIVATE_, FIELD_>(reporter, item, name, standard)
{
}

ErrorStaticNonfinalPrivateFieldName::~ErrorStaticNonfinalPrivateFieldName()
{
}


REGISTER_DESCRIPTION(ErrorStaticNonfinalProtectedFieldName);

ErrorStaticNonfinalProtectedFieldName::ErrorStaticNonfinalProtectedFieldName()
{
}

ErrorStaticNonfinalProtectedFieldName::ErrorStaticNonfinalProtectedFieldName(Reporter* const reporter, AstItem* const item, 
                                                                             const string& name,
                                                                             const string& standard) :
        ErrorNameStandard<true, false, PROTECTED_, FIELD_>(reporter, item, name, standard)
{
}

ErrorStaticNonfinalProtectedFieldName::~ErrorStaticNonfinalProtectedFieldName()
{
}


REGISTER_DESCRIPTION(ErrorStaticNonfinalPublicFieldName);

ErrorStaticNonfinalPublicFieldName::ErrorStaticNonfinalPublicFieldName()
{
}

ErrorStaticNonfinalPublicFieldName::ErrorStaticNonfinalPublicFieldName(Reporter* const reporter, AstItem* const item, 
                                                                 const string& name,
                                                                 const string& standard) :
        ErrorNameStandard<true, false, PUBLIC_, FIELD_>(reporter, item, name, standard)
{
}

ErrorStaticNonfinalPublicFieldName::~ErrorStaticNonfinalPublicFieldName()
{
}
