#ifndef ErrorNoBreakInCaseStatement_h
#include "ErrorNoBreakInCaseStatement.h"
#endif

#ifndef ErrorRegistry_h
#include "ErrorRegistry.h"
#endif

using namespace doctorj;

REGISTER_DESCRIPTION(ErrorNoBreakInCaseStatement);

ErrorNoBreakInCaseStatement::ErrorNoBreakInCaseStatement()
{
}

ErrorNoBreakInCaseStatement::ErrorNoBreakInCaseStatement(Reporter* const reporter, AstItem* const item) :
        SyntaxError(reporter, item)
{
}

ErrorNoBreakInCaseStatement::~ErrorNoBreakInCaseStatement()
{
}

string ErrorNoBreakInCaseStatement::title() const
{
    return "Case Statement Ends without Break";
}

void ErrorNoBreakInCaseStatement::writeDescription(ostream& os) const
{
    os << "The case statement falls through to the following case statement." << endl;
    os << "Use 'fallthrough' to denote that this is intentional." << endl;
}

string ErrorNoBreakInCaseStatement::message() const
{
    return "case statement does not end with break or commented fallthrough";
}
