#ifndef ErrorNoDefaultCase_h
#include "ErrorNoDefaultCase.h"
#endif

#ifndef ErrorRegistry_h
#include "ErrorRegistry.h"
#endif


using namespace doctorj;

REGISTER_DESCRIPTION(ErrorNoDefaultCase);

ErrorNoDefaultCase::ErrorNoDefaultCase()
{
}

ErrorNoDefaultCase::ErrorNoDefaultCase(Reporter* const reporter, AstItem* const item) :
        SyntaxError(reporter, item)
{
}

ErrorNoDefaultCase::~ErrorNoDefaultCase()
{
}

string ErrorNoDefaultCase::title() const
{
    return "No Default Case in Switch Statement";
}

void ErrorNoDefaultCase::writeDescription(ostream& os) const
{
    os << "The switch statement does not have a default case." << endl;
}

string ErrorNoDefaultCase::message() const
{
    return "The switch statement does not have a default case";
}
