#ifndef ErrorObjectSubclassesCompared_h
#include "ErrorObjectSubclassesCompared.h"
#endif

#ifndef ErrorRegistry_h
#include "ErrorRegistry.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

using namespace doctorj;

ErrorObjectSubclassesCompared::ErrorObjectSubclassesCompared()
{
}

ErrorObjectSubclassesCompared::ErrorObjectSubclassesCompared(Reporter* const reporter, 
                                                             AstEqualityExpression* const ee,
                                                             const string& type)
        : SyntaxError(reporter, ee), type_(type)
{
}

ErrorObjectSubclassesCompared::~ErrorObjectSubclassesCompared()
{
}

string ErrorObjectSubclassesCompared::title() const
{
    return "Object Subclasses Compared with " + comp();
}

void ErrorObjectSubclassesCompared::writeDescription(ostream& os) const
{
    os << "Subclasses of java.lang.Object compared with " << comp() << ", not equals()" << endl;
}

string ErrorObjectSubclassesCompared::message() const
{
    return "Subclasses of java.lang.Object (" + type_ + ") compared with " + comp() + ", not equals()";
}


REGISTER_DESCRIPTION(ErrorObjectSubclassesComparedWithEqEq);

ErrorObjectSubclassesComparedWithEqEq::ErrorObjectSubclassesComparedWithEqEq()
{
}

ErrorObjectSubclassesComparedWithEqEq::ErrorObjectSubclassesComparedWithEqEq(Reporter* const reporter, 
                                                                             AstEqualityExpression* const ee,
                                                                             const string& type)
        : ErrorObjectSubclassesCompared(reporter, ee, type)
{
}

ErrorObjectSubclassesComparedWithEqEq::~ErrorObjectSubclassesComparedWithEqEq()
{
}

string ErrorObjectSubclassesComparedWithEqEq::comp() const
{
    return "==";
}


REGISTER_DESCRIPTION(ErrorObjectSubclassesComparedWithNotEq);

ErrorObjectSubclassesComparedWithNotEq::ErrorObjectSubclassesComparedWithNotEq()
{
}

ErrorObjectSubclassesComparedWithNotEq::ErrorObjectSubclassesComparedWithNotEq(Reporter* const reporter, 
                                                                               AstEqualityExpression* const ee,
                                                                               const string& type)
        : ErrorObjectSubclassesCompared(reporter, ee, type)
{
}

ErrorObjectSubclassesComparedWithNotEq::~ErrorObjectSubclassesComparedWithNotEq()
{
}

string ErrorObjectSubclassesComparedWithNotEq::comp() const
{
    return "!=";
}
