#ifndef ErrorReturnFromVoidMethod_h
#include "ErrorReturnFromVoidMethod.h"
#endif

#ifndef ErrorRegistry_h
#include "ErrorRegistry.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

using namespace doctorj;

REGISTER_DESCRIPTION(ErrorReturnFromVoidMethod);

ErrorReturnFromVoidMethod::ErrorReturnFromVoidMethod()
{
}

ErrorReturnFromVoidMethod::ErrorReturnFromVoidMethod(Reporter* const reporter, AstReturnStatement* const rs,
                                                     const string& method) :
        SyntaxError(reporter, rs), method_(method)
{
}

ErrorReturnFromVoidMethod::~ErrorReturnFromVoidMethod()
{
}

string ErrorReturnFromVoidMethod::title() const
{
    return "Return from Void Method";
}

void ErrorReturnFromVoidMethod::writeDescription(ostream& os) const
{
    os << "Return was used in a method that has a void return type." << endl;
}

string ErrorReturnFromVoidMethod::message() const
{
    return "return was used in method '" + method_ + "', which has a void return type";
}
