#ifndef ErrorUselessThisInMethodInvocation_h
#define ErrorUselessThisInMethodInvocation_h

#ifndef SyntaxError_h
#include "SyntaxError.h"
#endif

namespace doctorj 
{
    class AstMethodInvocationPrimary;
    
    class ErrorUselessThisInMethodInvocation : public SyntaxError 
    {
    public:
        
        ErrorUselessThisInMethodInvocation();

        /**
         * Creates the error for the method.
         */
        ErrorUselessThisInMethodInvocation(Reporter* const reporter, AstMethodInvocationPrimary* const mi);

        virtual ~ErrorUselessThisInMethodInvocation();

        /**
         * Returns the title of this error.
         */
        virtual string title() const;

        /**
         * Writes the long description of this error to the given output stream.
         */
        virtual void writeDescription(ostream& os) const;

        /**
         * Returns the message describing this error. 
         */
        virtual string message() const;

    private:
        /**
         * The name of the method.
         */
        string name_;

    };

}

#endif //! ErrorUselessThisInMethodInvocation_h
