#ifndef MethodHeaderSyntaxAnalyzer_h
#include "MethodHeaderSyntaxAnalyzer.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef ErrorMethodPackageAccess_h
#include "ErrorMethodPackageAccess.h"
#endif

#ifndef SynDebug_h
#include "SynDebug.h"
#endif

#ifndef std_iostream
#define std_iostream
#include <iostream>
#endif


using namespace std;

using namespace doctorj;

MethodHeaderSyntaxAnalyzer::MethodHeaderSyntaxAnalyzer(Reporter* const reporter,
                                                       AstMethodHeader* const header, 
                                                       AstItem* const returnType,
                                                       AstModifierList* const modifiers,
                                                       AstThrowsNameList* const throwsList) :
        Analyzer(reporter), 
     header_(header),
     returnType_(returnType),
     modifiers_(modifiers),
     throwsList_(throwsList)
{
    check();
}

MethodHeaderSyntaxAnalyzer::~MethodHeaderSyntaxAnalyzer()
{
}

void MethodHeaderSyntaxAnalyzer::check()
{
    DEBUG_SYNTAX_ANALYZER(cout << "checking method header: " << header_->name() << endl);

    if (modifiers_ == NULL) {
        ErrorMethodPackageAccess err(reporter(), header_);
        err.process();
    }
    
    //$$$ check against misspelled superclass method
    //$$$ check method declarator for argument near match
    //$$$ check for unused private method
    //$$$ check for unused protected method that does not override a prot method
}

char MethodHeaderSyntaxAnalyzer::category() const
{
    return 'S';
}
