#ifndef ReferencedImport_h
#include "ReferencedImport.h"
#endif

#ifndef SynDebug_h
#include "SynDebug.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef StringUtilities_h
#include "StringUtilities.h"
#endif

#ifndef Java_h
#include "Java.h"
#endif

#ifndef UserPreferences_h
#include "UserPreferences.h"
#endif

using namespace doctorj;
using namespace std;


ReferencedImport::ReferencedImport(AstImportDeclaration* const id) : id_(id), nReferences_(0)
{
    fullName_ = id->importee();
}

ReferencedImport::~ReferencedImport()
{
}

AstImportDeclaration* ReferencedImport::declaration() const
{
    return id_;
}

int ReferencedImport::numReferences() const
{
    return nReferences_;
}

void ReferencedImport::addReference()
{
    ++nReferences_;
}

string ReferencedImport::fullName() const
{
    return fullName_;
}

bool ReferencedImport::isUnused() const
{
    SYNLOGF("%s numReferences = %d", fullName().c_str(), numReferences());
    return numReferences() == 0;
}


ReferencedSingleImport::ReferencedSingleImport(AstImportDeclarationSingle* const id) : ReferencedImport(id)
{
    vector<string> pieces = StringUtilities::split(fullName(), ".");
    if (pieces.size() >= 1) {
        alias_ = pieces[pieces.size() - 1];
        SYNLOGF("alias of %s is %s", fullName().c_str(), alias_.c_str());
    }
}

ReferencedSingleImport::~ReferencedSingleImport()
{
}

string ReferencedSingleImport::alias() const
{
    return alias_;
}

bool ReferencedSingleImport::isExactMatch(const string& typeName) const
{
    return typeName == alias_;
}

bool ReferencedSingleImport::isMatch(const string& typeName) const
{
    return isExactMatch(typeName);
}


ReferencedOnDemandImport::ReferencedOnDemandImport(AstImportDeclarationOnDemand* const id) : 
        ReferencedImport(id), classes_(NULL)
{
    package_ = id->getName()->fullName(); // not importee, because that includes ".*"
    SYNLOGF("ReferencedOnDemandImport: package is %s", package_.c_str());

    SYNLOGF("loading class names that match %s", package_.c_str());
    UserPreferences* prefs = UserPreferences::get();
    JavaLoader* proj = JavaLoader::get(declaration(), prefs->sourcePath, prefs->classPath);
    classes_ = new vector<string>();
    if (proj->getTypesInPackage(package_, classes_)) {
        // there was a package
        checkable_ = true;
    }
    else {
        // it is not checkable (as set in the ctor)
        checkable_ = false;
    }
}

ReferencedOnDemandImport::~ReferencedOnDemandImport()
{
    if (classes_) {
        delete classes_;
    }
}

string ReferencedOnDemandImport::package() const
{
    return package_;
}

bool ReferencedOnDemandImport::isExactMatch(const string& typeName) const
{
    // never true for an on-demand import.
    return false;
}

bool ReferencedOnDemandImport::isMatch(const string& typeName) const
{
    // Go look at all the loaded packages. If the package is not loaded, flag
    // this import as being referenced, even though it might not be. If the
    // package is loaded, look through each of the types in the package for the
    // given type name. Return whether we found it.

//     if (!classes_) {
//         SYNLOGF("loading class names that match %s", package_.c_str());
//         UserPreferences* prefs = UserPreferences::get();
//         JavaLoader* proj = JavaLoader::get(declaration(), prefs->sourcePath, prefs->classPath);
//         classes_ = new vector<string>();
//         if (proj->getTypesInPackage(package_, classes_)) {
//             // there was a package
//             checkable_ = true;
//         }
//         else {
//             // it is not checkable (as set in the ctor)
//         }
//     }

    // if they asked for Foo, we'll look for our.package.Foo:
    string ptn = package_ + "." + typeName;
    
    vector<string>::const_iterator it   = classes_->begin();
    vector<string>::const_iterator stop = classes_->end();
    while (it != stop) {
        string name = *it;
        SYNLOGF("%s: comparing %s to %s", fullName().c_str(), name.c_str(), typeName.c_str());
        if (name == typeName) {
            SYNLOG("type found.");
            return true;
        }
        ++it;
    }
    
    SYNLOGF("%s type '%s' NOT found.", fullName().c_str(), typeName.c_str());
    return false;
}

bool ReferencedOnDemandImport::isUnused() const
{
    if (checkable_) {
        SYNLOGF("%s was checkable...", fullName().c_str());
        SYNLOGF("%s numReferences = %d", fullName().c_str(), numReferences());
        return numReferences() == 0;
    }
    else {
        SYNLOGF("%s was NOT checkable.", fullName().c_str());
        // we can't say for certain that this import was not used.
        return false;
    }
}
