#ifndef RuleExplicitTrueInConditional_h
#include "RuleExplicitTrueInConditional.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef Java_h
#include "Java.h"
#endif

#ifndef ErrorExplicitTrueInConditional_h
#include "ErrorExplicitTrueInConditional.h"
#endif

using namespace std;
using namespace doctorj;

RuleExplicitTrueInConditional::RuleExplicitTrueInConditional(Reporter* const reporter) : Rule(reporter)
{
}

RuleExplicitTrueInConditional::~RuleExplicitTrueInConditional()
{
}

void RuleExplicitTrueInConditional::process(AstEqualityExpressionEq* const ee)
{
    process((AstEqualityExpression*)ee);
}

void RuleExplicitTrueInConditional::process(AstEqualityExpressionNe* const ee)
{
    process((AstEqualityExpression*)ee);
}

void RuleExplicitTrueInConditional::process(AstEqualityExpression* const ee)
{
    if (JavaEqualityExpression::hasTrueLiteralInExpression(ee)) {
        (new ErrorExplicitTrueInConditional(reporter(), ee))->process();
    }
    traverse(ee);
}
