#ifndef RuleUnreferencedImport_h
#include "RuleUnreferencedImport.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef ErrorUnreferencedImport_h
#include "ErrorUnreferencedImport.h"
#endif

#ifndef SynDebug_h
#include "SynDebug.h"
#endif

#ifndef iterext_h
#include "iterext.h"
#endif

using namespace std;
using namespace doctorj;

RuleUnreferencedImport::RuleUnreferencedImport(Reporter* const reporter) : Rule(reporter)
{
}

RuleUnreferencedImport::~RuleUnreferencedImport()
{
}

void RuleUnreferencedImport::process(AstCompilationUnit* const cu)
{
    imports_.clear();
    
    AstImportDeclarationList* imports = cu->getImportDeclarationList();
    
    if (imports) {
        SYNLOG("we've got imports!");
        int nImports = imports->getImportDeclarationCount();
        for (int i = 0; i < nImports; ++i) {
            AstImportDeclaration* id = imports->getImportDeclaration(i);
            if (AstImportDeclarationSingle* ids = dynamic_cast<AstImportDeclarationSingle*>(id)) {
                imports_.add(ids);
            }
            else if (AstImportDeclarationOnDemand* idod = dynamic_cast<AstImportDeclarationOnDemand*>(id)) {
                imports_.add(idod);
            }
            else {
                cerr << "wtf? " << endl;
            }
        }

        AstTypeDeclarationList* types = cu->getTypeDeclarationList();
        if (types) {
            traverse(types);
        }

        vector<AstImportDeclaration*> unused = imports_.getUnusedImports();
        EACH(vector<AstImportDeclaration*>, unused, it) {
            AstImportDeclaration* imp = *it;
            ErrorUnreferencedImport* err = new ErrorUnreferencedImport(reporter(), imp);
            err->process();
        }
    }
    else {
        SYNLOG("no imports to see here, folks.  keep it moving ...");
        // no need to traverse
    }
    
}

void RuleUnreferencedImport::process(AstCompilationUnitEmpty* const cu)
{
    process((AstCompilationUnit*)cu);
}

void RuleUnreferencedImport::process(AstCompilationUnitImp* const cu)
{
    process((AstCompilationUnit*)cu);
}

void RuleUnreferencedImport::process(AstCompilationUnitImpTypes* const cu)
{
    process((AstCompilationUnit*)cu);
}

void RuleUnreferencedImport::process(AstCompilationUnitPkg* const cu)
{
    process((AstCompilationUnit*)cu);
}

void RuleUnreferencedImport::process(AstCompilationUnitPkgImp* const cu)
{
    process((AstCompilationUnit*)cu);
}

void RuleUnreferencedImport::process(AstCompilationUnitPkgImpTypes* const cu)
{
    process((AstCompilationUnit*)cu);
}

void RuleUnreferencedImport::process(AstCompilationUnitPkgTypes* const cu)
{
    process((AstCompilationUnit*)cu);
}

void RuleUnreferencedImport::process(AstCompilationUnitTypes* const cu)
{
    process((AstCompilationUnit*)cu);
}

void RuleUnreferencedImport::process(AstName* const name)
{
    SYNLOGF("name: %s", name->text().c_str());
    
    if (name->text().find(".") == string::npos) {
        SYNLOGF("checking name: %s", name->text().c_str());
        imports_.checkForMatch(name->text());
    }
    else {
        SYNLOGF("skipping name: %s", name->text().c_str());
    }
}
