#ifndef SequenceOrder_h
#include "SequenceOrder.h"
#endif

#ifndef SynDebug_h
#include "SynDebug.h"
#endif

#ifndef std_iostream
#define std_iostream
#include <iostream>
#endif

using namespace doctorj;
using namespace std;

ostream& doctorj::operator<<(ostream& os, const SequenceOrder& so)
{
    os << "{ access=>"  << so.access_ << ", "
       << "finality=>"  << so.finality_ << ", "
       << "ownership=>" << so.ownership_ << ", "
       << "type=>"      << so.type_ << ", "
       << "name=>"      << so.name_ << " }";
    return os;
}

/**
 * Returns a value for the matching-ness of the two strings.
 */
static int compare(const string& a, const string& b)
{
    return a == b ? 10 : (a == "*" || b == "*" ? 5 : -5);
}

static int exactMatch(const string& a, const string& b)
{
    return a == b;
}

static int approxMatch(const string& a, const string& b)
{
    return a == b || a == "" || a == "*" || b == "" || b == "*";
}

/**
 * Returns whether the strings conflict.
 */
static bool nonconflict(const string& a, const string& b)
{
    return a == b || a.length() == 0 || b.length() == 0;
}

SequenceOrder::SequenceOrder()
{
}

SequenceOrder::SequenceOrder(const string& access,
                             const string& finality,
                             const string& ownership,
                             const string& type,
                             const string& name) :
        access_(access),
     finality_(finality),
     ownership_(ownership),
     type_(type),
     name_(name)
{
}

SequenceOrder::~SequenceOrder()
{
}

int SequenceOrder::matchValue(const string& access,
                              const string& finality,
                              const string& ownership,
                              const string& type,
                              const string& name) const
{
    // If the names are equal, and nothing is in conflict, this has a very high
    // rating.

    int mv = 0;
    
    if (exactMatch(name,      name_)      && 
        exactMatch(access,    access_)    && 
        exactMatch(finality,  finality_)  && 
        exactMatch(ownership, ownership_) && 
        exactMatch(type,      type_)) {
        mv = 10;
    }
    else if (approxMatch(access,    access_)    && 
             approxMatch(finality,  finality_)  && 
             approxMatch(ownership, ownership_) && 
             approxMatch(type,      type_)) {
        if (exactMatch(name, name_)) {
            mv = 7;
        }
        else if (approxMatch(name, name_)) {
            mv = 5;
        }
    }

    DEBUG_SYNTAX_ANALYZER(cout << "    matchValue(" << access << ", " << finality << ", " << ownership << ", " << type << ", " << name << ")" << endl);
    DEBUG_SYNTAX_ANALYZER(cout << "    this = " << *this << endl);
    DEBUG_SYNTAX_ANALYZER(cout << "    match value: " << mv << endl);

    return mv;
}
