#ifndef RuleTest_h
#include "RuleTest.h"
#endif

#ifndef RuleEmptyIfStatement_h
#include "RuleEmptyIfStatement.h"
#endif

#ifndef ErrorEmptyIfStatement_h
#include "ErrorEmptyIfStatement.h"
#endif

using namespace doctorj;

char ruleName[] = "RuleEmptyIfStatement";

class RuleEmptyIfStatementTest : 
    public RuleTest<ruleName, RuleEmptyIfStatement, ErrorEmptyIfStatement>
{
public:
    virtual void getContents(std::vector<std::vector<std::string> >* const contents) {
        std::vector<std::string> vec0;
        vec0.push_back("class RuleEmptyIfStatement {");
        vec0.push_back("    RuleEmptyIfStatement() {");
        vec0.push_back("        if (false);"); 
        vec0.push_back("    }");
        vec0.push_back("}");
        contents->push_back(vec0);
                
        std::vector<std::string> vec1;
        vec1.push_back("class RuleEmptyIfStatement {");
        vec1.push_back("    RuleEmptyIfStatement() {");
        vec1.push_back("        if (false) {"); 
        vec1.push_back("            // nothing"); 
        vec1.push_back("        }");
        vec1.push_back("    }");
        vec1.push_back("}");
        contents->push_back(vec1);
    }

    virtual int errorsExpected(int num) const { 
        return num == 0 ? 1 : 0; 
    }
    
};

int main(int argc, char** argv) 
{
    RuleEmptyIfStatementTest t;
    t.run();
    cout << "empty for statement rule test results: " << t << endl;
    return t.nerrors();
}
