#ifndef RuleTest_h
#include "RuleTest.h"
#endif

#ifndef RuleEmptyWhileStatement_h
#include "RuleEmptyWhileStatement.h"
#endif

#ifndef ErrorEmptyWhileStatement_h
#include "ErrorEmptyWhileStatement.h"
#endif

using namespace doctorj;

char ruleName[] = "RuleEmptyWhileStatement";

class RuleEmptyWhileStatementTest : 
    public RuleTest<ruleName, RuleEmptyWhileStatement, ErrorEmptyWhileStatement>
{
public:
    virtual void getContents(std::vector<std::vector<std::string> >* const contents) {
        std::vector<std::string> vec0;
        vec0.push_back("class RuleEmptyWhileStatement {");
        vec0.push_back("    RuleEmptyWhileStatement() {");
        vec0.push_back("        while (false);"); 
        vec0.push_back("    }");
        vec0.push_back("}");
        contents->push_back(vec0);
                
        std::vector<std::string> vec1;
        vec1.push_back("class RuleEmptyWhileStatement {");
        vec1.push_back("    RuleEmptyWhileStatement() {");
        vec1.push_back("        while (false) {"); 
        vec1.push_back("            // nothing"); 
        vec1.push_back("        }");
        vec1.push_back("    }");
        vec1.push_back("}");
        contents->push_back(vec1);
    }

    virtual int errorsExpected(int num) const { 
        return num == 0 ? 1 : 0; 
    }

};

int main(int argc, char** argv) 
{
    RuleEmptyWhileStatementTest t;
    t.run();
    cout << "empty while statement rule test results: " << t << endl;
    return t.nerrors();
}
