#ifndef RuleTest_h
#include "RuleTest.h"
#endif

#ifndef RuleExplicitTrueInConditional_h
#include "RuleExplicitTrueInConditional.h"
#endif

#ifndef ErrorExplicitTrueInConditional_h
#include "ErrorExplicitTrueInConditional.h"
#endif

using namespace doctorj;

char ruleName[] = "RuleExplicitTrueInConditional";

class RuleExplicitTrueInConditionalTest : 
    public RuleTest<ruleName, RuleExplicitTrueInConditional, ErrorExplicitTrueInConditional>
{
public:
    virtual void getContents(std::vector<std::vector<std::string> >* const contents) {
        std::vector<std::string> vec0;
        vec0.push_back("class RuleExplicitTrueInConditional {");
        vec0.push_back("    void foo(bool b) {");
        vec0.push_back("        if (b == true) {"); 
        vec0.push_back("        }"); 
        vec0.push_back("    }");
        vec0.push_back("}");
        contents->push_back(vec0);
        
        std::vector<std::string> vec1;
        vec1.push_back("class RuleExplicitTrueInConditional {");
        vec1.push_back("    void foo(bool b) {");
        vec1.push_back("        if (true == b) {"); 
        vec1.push_back("        }"); 
        vec1.push_back("    }");
        vec1.push_back("}");
        contents->push_back(vec1);
        
        std::vector<std::string> vec2;
        vec2.push_back("class RuleExplicitTrueInConditional {");
        vec2.push_back("    void foo(bool b) {");
        vec2.push_back("        if (b == (true)) {"); 
        vec2.push_back("        }"); 
        vec2.push_back("    }");
        vec2.push_back("}");
        contents->push_back(vec2);
    }

};

int main(int argc, char** argv) 
{
    RuleExplicitTrueInConditionalTest t;
    t.run();
    cout << "explicit true in test results: " << t << endl;
    return t.nerrors();
}
