#ifndef RuleTest_h
#include "RuleTest.h"
#endif

#ifndef RuleGenericCatch_h
#include "RuleGenericCatch.h"
#endif

#ifndef ErrorGenericCatch_h
#include "ErrorGenericCatch.h"
#endif

using namespace doctorj;

char ruleName[] = "RuleGenericCatch";

class RuleGenericCatchTest : 
    public RuleTest<ruleName, RuleGenericCatch, ErrorGenericCatch>
{
public:
    virtual void getContents(std::vector<std::vector<std::string> >* const contents) {
        std::vector<std::string> vec0;
        vec0.push_back("class RuleGenericCatch {");
        vec0.push_back("    void foo() {");
        vec0.push_back("        try {");
        vec0.push_back("        }");
        vec0.push_back("        catch (Exception e) { ");
        vec0.push_back("        }");
        vec0.push_back("    }");
        vec0.push_back("}");
        contents->push_back(vec0);
                
        std::vector<std::string> vec1;
        vec1.push_back("class RuleGenericCatch {");
        vec1.push_back("    void foo() {");
        vec1.push_back("        try {");
        vec1.push_back("        }");
        vec1.push_back("        catch (java.lang.Exception e) { ");
        vec1.push_back("        }");
        vec1.push_back("    }");
        vec1.push_back("}");
        contents->push_back(vec1);

        std::vector<std::string> vec2;
        vec2.push_back("class RuleGenericCatch {");
        vec2.push_back("    void foo() {");
        vec2.push_back("        try {");
        vec2.push_back("        }");
        vec2.push_back("        catch (java.lang.Throwable t) { ");
        vec2.push_back("        }");
        vec2.push_back("    }");
        vec2.push_back("}");
        contents->push_back(vec2);

        std::vector<std::string> vec3;
        vec3.push_back("class RuleGenericCatch {");
        vec3.push_back("    void foo() {");
        vec3.push_back("        try {");
        vec3.push_back("        }");
        vec3.push_back("        catch (Throwable t) { ");
        vec3.push_back("        }");
        vec3.push_back("    }");
        vec3.push_back("}");
        contents->push_back(vec3);

        std::vector<std::string> vec4;
        vec4.push_back("class RuleGenericCatch {");
        vec4.push_back("    void foo() {");
        vec4.push_back("        try {");
        vec4.push_back("        }");
        vec4.push_back("        catch (java.io.IOException e) { ");
        vec4.push_back("        }");
        vec4.push_back("    }");
        vec4.push_back("}");
        contents->push_back(vec4);
    }

    virtual int errorsExpected(int num) const { 
        return num < 4 ? 1 : 0; 
    }

};

int main(int argc, char** argv) 
{
    RuleGenericCatchTest t;
    t.run();
    cout << "generic catch rule test results: " << t << endl;
    return t.nerrors();
}
