#ifndef Test_h
#include "Test.h"
#endif

#ifndef SequenceOrder_h
#include "SequenceOrder.h"
#endif

#ifndef SynDebug_h
#include "SynDebug.h"
#endif

#ifndef Log_h
#include "Log.h"
#endif

using namespace doctorj;
using namespace std;

class SequenceOrderTest : public Test 
{
public:
    SequenceOrderTest();
    
    virtual ~SequenceOrderTest();

    virtual void run();
};


SequenceOrderTest::SequenceOrderTest() : Test(true)
{
}

SequenceOrderTest::~SequenceOrderTest()
{
}

void SequenceOrderTest::run() 
{
    SequenceOrder mso("public", "static", "*", "method", "main");
    int mvnm = mso.matchValue("public", "static", "nonfinal", "method", "main");
    TESTEQ(7, mvnm, "match value of named method");

    int mvum = mso.matchValue("public", "static", "nonfinal", "method", "");
    TESTEQ(5, mvum, "match value of unnamed method");

    int mvma = mso.matchValue("private", "static", "nonfinal", "method", "");
    TESTEQ(0, mvma, "match value of mismatched access");

}

int main(int argc, char** argv) 
{
    Log::setEnabled();
    
    SequenceOrderTest t;
    t.run();
    cout << "sequence order test results: " << t << endl;
    return t.nerrors();
}
