#ifndef Writer_h
#include "Writer.h"
#endif

#include <stdio.h>

#ifndef std_vector
#define std_vector
#include <vector>
#endif

using namespace std;
using namespace doctorj;


int Writer::INDENT_SPACES = 4;

int Writer::PAGE_WIDTH = 78;

char Writer::PERIOD = '.';

Writer::Writer(ostream& os) : level_(0), os_(os)
{
}

Writer::~Writer()
{
}

void Writer::incrementLevel()
{
    ++level_;
}

void Writer::decrementLevel()
{
    --level_;
}

int Writer::level()
{
    return level_;
}

void Writer::setLevel(int l)
{
    level_ = l;
}

void Writer::indent()
{
    if (level_ >= 0) {
        string spaces(level_ * INDENT_SPACES, ' ');
        os_ << spaces;
    }
    else {
        cerr << "level is below 0!" << endl;
    }
}

void Writer::writeLeft(const string& label)
{
    write(label, "");
}

void Writer::fill(char ch)
{
    if (level_ >= 0) {
        indent();
        int i = INDENT_SPACES * level_;
        string f(PAGE_WIDTH - i, ch);
        os_ << f << endl;
    }
    else {
        cerr << "level is below 0!" << endl;
    }
}

void Writer::blankLine()
{
    os_ << endl;
}

void Writer::write(const string& label, double v)
{
    // Round off to just one decimal place (or maybe make this yet another
    // option?):
    const int    MAX_CHARS = 100;
    vector<char> vc(MAX_CHARS);
    int          nchars = sprintf(&vc[0], "%.1f", v);
    string       str(vc.begin(), vc.begin() + nchars);
    writeString(label, str);
}
