#ifndef Test_h
#include "Test.h"
#endif

#ifndef File_h
#include "File.h"
#endif

#include <unistd.h>

using namespace doctorj;

class OutFileTest : public Test 
{
public:
    OutFileTest();
    virtual void run();
};

OutFileTest::OutFileTest() : Test(true)
{
}

void OutFileTest::run() 
{
    {
        unlink("/tmp/this/is/a/test/DosFile.txt");
        rmdir("/tmp/this/is/a/test");
        rmdir("/tmp/this/is/a");
        rmdir("/tmp/this/is");
        rmdir("/tmp/this");
        char* ofname = "/tmp/this/is/a/test/DosFile.txt";
        OutFile ofile(ofname, "this\nis\na\ntest", "\r\n");
        ofile.write();
    }

    {
        unlink("/tmp/this/is/a/test/MacFile.txt");
        rmdir("/tmp/this/is/a/test");
        rmdir("/tmp/this/is/a");
        rmdir("/tmp/this/is");
        rmdir("/tmp/this");
        char* ofname = "/tmp/this/is/a/test/MacFile.txt";
        OutFile ofile(ofname, "this\nis\na\ntest", "\r");
        ofile.write();
    }

    {
        unlink("/tmp/this/is/a/test/UnixFile.txt");
        rmdir("/tmp/this/is/a/test");
        rmdir("/tmp/this/is/a");
        rmdir("/tmp/this/is");
        rmdir("/tmp/this");
        char* ofname = "/tmp/this/is/a/test/UnixFile.txt";
        OutFile ofile(ofname, "this\nis\na\ntest", "\n");
        ofile.write();
    }
}

int main(int argc, char** argv) 
{
    OutFileTest t;
    t.run();
    cout << "outfile test results: " << t << endl;
    return t.nerrors();
}
