#ifndef Yagol_h
#include "Yagol.h"
#endif

#ifndef std_iostream
#define std_iostream
#include <iostream>
#endif

#ifndef std_iterator
#define std_iterator
#include <iterator>
#endif

#ifndef std_string
#define std_string
#include <string>
#endif

#ifndef std_vector
#define std_vector
#include <vector>
#endif

using namespace std;

int main(int argc, char** argv)
{
    string greeting("hello");
    vector<string> audience;
    audience.push_back("world");
    
    yagol::AppOptionSet optset(yagol::AppOptionSet::STRICT_ARGUMENTS | yagol::AppOptionSet::HELP_ON_ERROR,
                               string("hwygl"), string("a hello world application using Yagol"));
    optset.addEnvironmentVariable("HWYGL_OPTS");
    optset.addConfigFile("~/.hwyglrc");
    optset.addOption("greeting", "what to say to the audience", &greeting);
    optset.addOption("audience", "those being greeted",         &audience);
    optset.setVersion("HelloWorld", "1.2.3");
    // optset.setAuthor("Carl Gustav", "cgustav@incava.org");
    // optset.setLicense(yagol::License::LGPL);
    
    cout << "processing." << endl;
    optset.process(argc, argv);
    cout << "done processing." << endl;

    if (!optset.displayedVersion() && !optset.showedHelp()) {
        cout << greeting << ", ";
        if (audience.size() == 1) {
            cout << *(audience.begin());
        }
        else {
            copy(audience.begin(), audience.end() - 2, ostream_iterator<string>(cout, ", "));
            cout << *(audience.end() - 2) << " and " << *(audience.end() - 1);
        }
        cout << endl;
    }
    
    return 0;
}
