#include <iostream>
#include <string>
#include <vector>

#ifndef Test_h
#include "Test.h"
#endif

#ifndef Yagol_h
#include "Yagol.h"
#endif

using namespace std;

class MatchTest : public Test {
public:
    MatchTest();

    virtual ~MatchTest();

    void run();
};


MatchTest::MatchTest()
{
}

MatchTest::~MatchTest()
{
}

void MatchTest::run()
{
    yagol::AppOptionSet app("myapp");
    
    int media = 4;
    string medicine = "prozac";
    bool mediate = true;
    double medieval = 3.14;
    string mediator("Dr. Marvin Murphy");
    
    app.addOption("media",    "number of media",      &media);
    app.addOption("medicine", "the type of medicine", &medicine);
    app.addOption("mediate",  "whether to mediate",   &mediate);
    app.addOption("medieval", "something medieval",   &medieval);
    app.addOption("mediator", "who is mediating",     &mediator);

    {
        char* argv[] = { "myapp", "--med", "1066" };
        int argc = sizeof(argv) / sizeof(argv[0]);
        app.process(argc, argv); 
    }

    {
        char* argv[] = { "myapp", "--medi", "fred" };
        int argc = sizeof(argv) / sizeof(argv[0]);
        app.process(argc, argv); 
    }

    {
        // this should match "media" exactly
        char* argv[] = { "myapp", "--media", "NBC" };
        int argc = sizeof(argv) / sizeof(argv[0]);
        app.process(argc, argv); 
    }

    {
        char* argv[] = { "myapp", "--nomediat" };
        int argc = sizeof(argv) / sizeof(argv[0]);
        app.process(argc, argv); 
    }

}

int main(int argc, char** argv)
{
    MatchTest t;
    t.run();
    cout << "match test results: " << t << endl;
    return t.nerrors();
}
