#ifndef Test_h
#include "Test.h"
#endif

#ifndef Yagol_h
#include "Yagol.h"
#endif

#ifndef std_fstream
#define std_fstream
#include <fstream>
#endif

#ifndef yagol_unistd_h
#define yagol_unistd_h
#include <unistd.h>
#endif

using namespace std;

class YagolAppOptionSetTest : public Test 
{
public:
    YagolAppOptionSetTest();
    virtual void run();
};

YagolAppOptionSetTest::YagolAppOptionSetTest() : Test(true)
{
}

void YagolAppOptionSetTest::run() 
{
    yagol::AppOptionSet opts("thisapp", "some application");

    // straight from the command line
    string str1("defstr1");
    int int1(1);
    bool bool1(false);
    opts.addOption("str1",  "String number one",    &str1);
    opts.addOption("int1",  "Integer number one",   &int1);
    opts.addOption("bool1", "boolean number one",   &bool1);

    // only in the "configuration file"
    string str2("defstr2");
    int int2(2);
    bool bool2(true);
    opts.addOption("str2",  "String number two",    &str2);
    opts.addOption("int2",  "Integer number two",   &int2);
    opts.addOption("bool2", "boolean number two",   &bool2);

    // in the configuration file, but overridden by the command line
    string str3("defstr3");
    int int3(3);
    bool bool3(true);
    opts.addOption("str3",  "String number three",  &str3);
    opts.addOption("int3",  "Integer number three", &int3);
    opts.addOption("bool3", "boolean number three", &bool3);
    
    // valid options
    
    // dump a usage statement, a la --help
    opts.writeUsage(cout);

    string rcname("~/appoptset.rc");
    // we can't use tildes or strings with ofstream
    string rcexp = opts.expandFileName(rcname);
    ofstream rcfile(rcexp.c_str());

    rcfile << "str2 = string2" << endl;
    rcfile << "int2 = 22" << endl;
    rcfile << "bool2 = yes" << endl;
    rcfile << "" << endl;
    rcfile << "str3 = XXX" << endl;
    rcfile << "int3 = 0947" << endl;
    rcfile << "bool3 = yes" << endl;
    rcfile << "" << endl;
    rcfile.close();

    opts.addConfigFile(rcname);

    // pseudo command-line
    char* args[] = {
        "appname",
        "--str1", "string1",
        "--int1", "11",
        "--bool1",

        // an unused argument
        "bogus1",

        // not messing with the second set of options

        // "override" the third set of options
        "--str3", "string3",
        "--int3", "33",
        "--nobool3",

        // another unused argument
        "bogus2"
    };
    const int NARGS = sizeof(args) / sizeof(args[0]);

    // process the command line
    try {
        opts.process(NARGS, args);
    }
    catch (const yagol::Exception& e) {
        FAIL("exception thrown during processing");
    }

    // unprocessed arguments
    vector<char*> unproc = opts.getUnprocessedArgs();

    // tests
    TESTEQ(unproc.size(), 2UL,       "should have two unprocessed arguments");
    TESTEQ(str1,          "string1", "processing of string one");
    TESTEQ(int1,          11,        "processing of integer one");
    TESTEQ(bool1,         true,      "processing of boolean one");

    TESTEQ(str2,          "string2", "processing of string two");
    TESTEQ(int2,          22,        "processing of integer two");
    TESTEQ(bool2,         true,      "processing of boolean two");

    TESTEQ(str3,          "string3", "processing of string three");
    TESTEQ(int3,          33,        "processing of integer three");
    TESTEQ(bool3,         false,     "processing of boolean three");

    unlink(rcexp.c_str());
}

int main(int argc, char** argv) 
{
    YagolAppOptionSetTest t;
    t.run();
    cout << "yagol app option set test results: " << t << endl;
    t.writeReport(cout);
    return t.nerrors();
}
