#ifndef Test_h
#include "Test.h"
#endif

#ifndef Yagol_h
#include "Yagol.h"
#endif

#ifndef Log_h
#include "Log.h"
#endif

class YagolOptionStringTest : public Test 
{
public:
    YagolOptionStringTest();
    virtual void run();
};

YagolOptionStringTest::YagolOptionStringTest() : Test(true)
{
    doctorj::Log::setEnabled(doctorj::Log::ALL);
}

void YagolOptionStringTest::run() 
{
    string s("xxx");
    yagol::OptionGeneric<string> gos("gos1", "yagol option string #1", &s);
    TESTEQ(gos.defaultValue(), s, "default value appropriately set");

    LOG(0, "running first check");
    {
        char* args[] = { "--gos1", "yyy" };
        const int NARGS = sizeof(args) / sizeof(args[0]);
        int pos = 0;
        int nArgs = gos.consume("gos1", pos, NARGS, args);
        TESTEQ(nArgs, 2, "proper number of arguments consumed");
        TESTEQ(s, "yyy", "string set to yyy");
    }

    LOG(0, "running second check");
    {
        char* args[] = { "--gos1" };
        const int NARGS = sizeof(args) / sizeof(args[0]);
        int pos = 0;
        try {
            LOG(0, "consuming");
            gos.consume("gos1", pos, NARGS, args);
            LOG(0, "done consuming");
            FAIL("exception should have been thrown by string argument without value");
        }
        catch (const yagol::Exception& e) {
            LOG(0, "caught exception");
            // as expected
        }
    }

    LOG(0, "running third check");
    {
        char* args[] = { "dummy", "--gos1", "zzz" };
        const int NARGS = sizeof(args) / sizeof(args[0]);
        int pos = 0;
        bool match = gos.tagMatches(string(string(args[pos]), 2));
        TESTEQ(match, false, "unsuccessful match of argument");

        pos = 1;
        match = gos.tagMatches(string(string(args[pos]), 2));
        TESTEQ(match, true, "successful match of argument");
        int nArgs = gos.consume("gos1", pos, NARGS, args);
        TESTEQ(nArgs, 2, "proper number of arguments consumed");
        TESTEQ(s, "zzz", "string set to zzz");
    }
}

int main(int argc, char** argv) 
{
    YagolOptionStringTest t;
    t.run();
    cout << "yagol option string test results: " << t << endl;
    t.writeReport(cout);
    return t.nerrors();
}
