// --- BEGIN COPYRIGHT BLOCK ---
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; version 2 of the License.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
//
// (C) 2007 Red Hat, Inc.
// All rights reserved.
// --- END COPYRIGHT BLOCK ---
package com.netscape.admin.certsrv;

import java.util.Hashtable;

/**
 * The CMSRemoteClassLoader is designed to load classes from remote
 * Certificate Servers. Classes are acquired via the admin channel
 * used by the Certificate Server console.
 *
 * @author Jack Pan-Chen
 * @version $Revision$, $Date$
 * @date	 	02/13/97
 * @see ClassLoader
 * @deprecated The PKI console will be removed once there are CLI equivalents of desired console features.
 */
@Deprecated(since="10.14.0", forRemoval=true)
class CMSRemoteClassLoader extends ClassLoader {

    /*==========================================================
     * variables
     *==========================================================*/
    private Hashtable<String, Class<?>> mCache = new Hashtable<>();     // stores classes

	/*==========================================================
     * constructors
     *==========================================================*/
    public CMSRemoteClassLoader(CMSServerInfo info) {
        //mAdmin = info.getAdmin();
    }

    /*==========================================================
	 * public methods
     *==========================================================*/

	/**
	 * Attempts to load the named class.
	 *
	 * @param name the fully-qualified class name, in '.' form.
	 * @return the Class object of the named class.
	 * @throws ClassNotFoundException if the class cannot be found.
	 */
    @Override
    public synchronized Class<?> loadClass(String name, boolean resolve)
        throws ClassNotFoundException
    {
        Class<?> c = mCache.get(name);

        if (c == null) {
            String path = name.replace('.', '/') + ".class";
            try {
                byte data[] = loadClassData(path);
                c = defineClass(name,data, 0, data.length);
                mCache.put(name, c);
            } catch (Exception e) {
            }
        }
        if (resolve)
            resolveClass(c);
        return c;

    }

	/**
	 * Attempts to load the named class.
	 *
	 * @param name the fully-qualified class name, in '.' form.
	 * @return the Class object of the named class.
	 * @throws ClassNotFoundException if the class cannot be found.
	 */
	@Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, true);
    }

    /*==========================================================
	 * private methods
     *==========================================================*/

    /**
     * Retrieves the class specified by path from the server side.
     *
     * @param class name
     * @return an InputStream for the resource.
     * @throws Exception on any error while loading the resource.
     */
    private byte[] loadClassData(String path)
        throws EAdminException
    {
        //load the class here from server side
        return null;
    }

}
