"Utility functions for docstring manipulations."

__author__ = "Anders Logg <logg@simula.no>"
__date__ = "2010-08-26"
__copyright__ = "Copyright (C) 2010 " + __author__
__license__  = "GNU GPL version 3 or any later version"

# Modified by Kristian B. Oelgaard, 2010.

# Last changed: 2010-09-15

import re

def indent(string, num_spaces):
    "Indent given text block given number of spaces"
    return "\n".join(num_spaces*" " + l for l in string.split("\n"))

def add_links(text, classnames, link_type):
    "Add crosslinks for classes"
    for classname in classnames:
        p = re.compile(r"\b_%s_\b" % classname)
        text = p.sub("%s`%s`" % (link_type, classname), text)

    return text

