# This module dynamically loads mpi. This needs to be done before any other modules
# loads mpi. This is because the shared mpi library needs to be loaded with the
# RTLD_GLOBAL options. See
#
#   <http://www.open-mpi.org/faq/?category=running#loading-libmpi-dynamically>
#

import ctypes
import platform

if platform.system() == 'Darwin':
    libmpi = 'libmpi.0.dylib'
else:
    libmpi = 'libmpi.so'

ctypes.CDLL(libmpi, ctypes.RTLD_GLOBAL)
