// Auto generated SWIG file for Python interface of DOLFIN
//
// Copyright (C) 2012 Kristian B. Oelgaard
//
// This file is part of DOLFIN.
//
// DOLFIN is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// DOLFIN is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with DOLFIN. If not, see <http://www.gnu.org/licenses/>.
//

// Autogenerated docstrings file, extracted from the DOLFIN source C++ files.

// Documentation extracted from: (module=plot, header=plot.h)
%feature("docstring")  dolfin::interactive "
Make the current plots interactive. If really is set, the interactive
mode is entered even if 'Q' has been pressed.
";

%feature("docstring")  dolfin::plot "
**Overloaded versions**

* plot\ (Variable&, title=\"\", mode=\"auto\")

  Plot variable of any supported type

* plot\ (Variable>, title=\"\", mode=\"auto\")

  Plot variable (shared_ptr version)

* plot\ (Variable&, parameters)

  Plot variable (parameter version)

* plot\ (Variable>, parameters)

  Plot variable (parameter, shared_ptr version)

* plot\ (expression, mesh, title=\"\", mode=\"auto\")

  Plot expression

* plot\ (expression, mesh, title=\"\", mode=\"auto\")

  Plot expression (shared_ptr version)

* plot\ (expression, mesh, parameters)

  Plot expression (parameter version)

* plot\ (expression, mesh, parameters)

  Plot expression (parameter, shared_ptr version)
";

// Documentation extracted from: (module=plot, header=VTKPlotter.h)
%feature("docstring")  dolfin::VTKPlotter "
This class enables visualization of various DOLFIN entities.  It
supports visualization of meshes, functions, expressions,
boundary conditions and mesh functions. It can plot data wrapped
in classes conforming to the GenericVTKPlottable interface.  The
plotter has several parameters that the user can set and adjust
to affect the appearance and behavior of the plot.

A plotter can be created and used in the following way:

  Mesh mesh = ...;
  VTKPlotter plotter(mesh);
  plotter.plot();

Parameters can be adjusted at any time and will take effect on
the next call to the plot() method. The following parameters
exist:

============== ============ ================ ====================================
 Name           Value type   Default value              Description
============== ============ ================ ====================================
 mode            String        \"auto\"         For vector valued functions,
                                              this parameter may be set to
                                              \"glyphs\" or \"displacement\".
                                              Scalars may be set to \"warp\" in
                                              2D only. A value of \"color\" is
                                              valid in all cases; for vectors,
                                              the norms are used. See below for
                                              a summary of default modes,
                                              used when set to \"auto\".
 interactive     Boolean     False            Enable/disable interactive mode
                                              for the rendering window.
                                              For repeated plots of the same
                                              object (animated plots), this
                                              parameter should be set to false.
 wireframe       Boolean     True for         Enable/disable wireframe
                             meshes, else     rendering of the object.
                             false
 title           String      Inherited        The title of the rendering
                             from the         window
                             name/label of
                             the object
 scale           Double      1.0              Adjusts the scaling of the
                                              warping and glyphs
 scalarbar       Boolean     False for        Hide/show the colormapping bar
                             meshes, else
                             true
 axes            Boolean     False            Show X-Y-Z axes.

 rescale         Boolean     True             Enable/disable recomputation
                                              of the scalar to color mapping
                                              on every iteration when performing
                                              repeated/animated plots of the same
                                              data. If both range_min and
                                              range_max are set, this parameter
                                              is ignored.
 range_min       Double                       Set lower range of data values.
                                              Disables automatic (re-)computation
                                              of the lower range.
 range_max       Double                       Set upper range of data values.
                                              Disables automatic (re-)computation
                                              of the upper range.
 elevate         Double      -65.0 for 2D     Set camera elevation.
                             warped scalars,
                             0.0 otherwise
 prefix          String      \"dolfin_plot_\"   Filename prefix used when
                                              saving plots to file in
                                              interactive mode. An integer
                                              counter is appended after the
                                              prefix.
 helptext        Boolean     True             Enable/disable the hover-over
                                              help-text in interactive
                                              mode
 window_width    Integer     600              The width of the plotting window
                                              in pixels
 window_height   Integer     400              The height of the plotting window
                                              in pixels
 tile_windows    Boolean     True             Automatically tile plot windows.

 key             String                       Key (id) of the plot window, used to
                                              decide if a new plotter should be
                                              created or a current one updated
                                              when called through the static
                                              plot() interface (in plot.h).
                                              If not set, the object's unique
                                              id (Variable::id) is used.
 input_keys      String      \"\"               Synthesize key presses, as if these
                                              keys are pressed by the user in
                                              the plot window.
                                              For example: \"ww++m\" shows the data
                                              as large points on a wireframe
                                              mesh.
 hide_above      Double                       If either of these are set, scalar
 hide_below      Double                       values above or below will not be
                                              shown in the plot.
============== ============ ================ ====================================

The default visualization mode for the different plot types are as follows:

=========================  ============================ =====================
 Plot type                  Default visualization mode   Alternatives
=========================  ============================ =====================
 Meshes                     Wireframe rendering          None
 2D scalar functions        Scalar warping               Color mapping
 3D scalar functions        Color mapping                None
 2D/3D vector functions     Glyphs (vector arrows)       Displacements,
                                                         Color mapping (norm)
=========================  ============================ =====================

Expressions and boundary conditions are also visualized
according to the above table.
";

%feature("docstring")  dolfin::VTKPlotter::VTKPlotter "
**Overloaded versions**

* VTKPlotter\ (Variable>)

  Create plotter for a variable. If a widget is supplied, this
  widget will be used for drawing, instead of a new top-level
  widget. Ownership is transferred.

* VTKPlotter\ (expression, mesh)

  Create plotter for an Expression with associated Mesh. If a
  widget is supplied, this widget will be used for drawing,
  instead of a new top-level widget. Ownership is transferred.
";

%feature("docstring")  dolfin::VTKPlotter::default_parameters "
Default parameter values
";

%feature("docstring")  dolfin::VTKPlotter::plot "
Plot the object
";

%feature("docstring")  dolfin::VTKPlotter::interactive "
Make the current plot interactive
";

%feature("docstring")  dolfin::VTKPlotter::write_png "
Save plot to PNG file (file suffix appended automatically, filename
optionally built from prefix)
";

%feature("docstring")  dolfin::VTKPlotter::write_pdf "
Save plot to PDF file (file suffix appended automatically, filename
optionally built from prefix)
";

%feature("docstring")  dolfin::VTKPlotter::key "
Return key (i.e., plotter id) of the object to plot
";

%feature("docstring")  dolfin::VTKPlotter::set_key "
Set the key (plotter id)
";

%feature("docstring")  dolfin::VTKPlotter::to_key "
Return default key (plotter id) of a Variable (object to plot).
";

%feature("docstring")  dolfin::VTKPlotter::azimuth "
Camera control
";

%feature("docstring")  dolfin::VTKPlotter::all_interactive "
Make all plot windows interactive. If really is set, the
interactive mode is entered even if 'Q' has been pressed.
";

