# -*- coding: utf-8 -*-
"""Shared skips for unit tests involving dolfin."""

# Copyright (C) 2014-2014 Aslak Wigdahl Bergersen
#
# This file is part of DOLFIN.
#
# DOLFIN is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# DOLFIN is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with DOLFIN. If not, see <http://www.gnu.org/licenses/>.

import pytest
from dolfin import *

# Standard fixture
fixture = pytest.fixture(scope='module')

# Skips with dependencies
skip_if_not_PETsc_or_not_slepc = \
                    pytest.mark.skipif(not has_linear_algebra_backend("PETSc") or not has_slepc(),
                                       reason='Skipping unit test(s) depending on PETSc and slepc.')
skip_if_not_HDF5 = pytest.mark.skipif(not has_hdf5(),
                                    reason="Skipping unit test(s) depending on HDF5.")
skip_if_not_PETSc = pytest.mark.skipif(not has_linear_algebra_backend("PETSc"),
                                       reason="Skipping unit test(s) depending on PETSc.")
skip_if_not_petsc4py = pytest.mark.skipif(not has_petsc4py(),
                                          reason="Skipping unit test(s) depending on petsc4py.")

# Skips with respect to parallel or serial
xfail_in_parallel = pytest.mark.xfail(MPI.size(mpi_comm_world()) > 1,
                                      reason="This test does not yet work in parallel.")
skip_in_parallel = pytest.mark.skipif(MPI.size(mpi_comm_world()) > 1,
                                      reason="This test should only be run in serial.")
skip_in_serial = pytest.mark.skipif(MPI.size(mpi_comm_world()) <= 1,
                                    reason="This test should only be run in parallel.")

# Skips with respect to linear algebra index type
skip_64bit_int = pytest.mark.skipif(cpp.common.sizeof_la_index() == 8,
                                    reason="This test does not work with 64-bit linear algebra indices.")
