/***************************************************************************
 *   Copyright (C) 2006 by Peter Penz                                      *
 *   peter.penz@gmx.at                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef DOLPHINCONTEXTMENU_H
#define DOLPHINCONTEXTMENU_H

#include <kpopupmenu.h>
#include <qpoint.h>
#include <qstring.h>
#include <qvaluelist.h>

class KPopupMenu;
class KFileItem;
class QPoint;
class QWidget;
class DolphinView;

/**
 * @brief Represents the context menu which appears when doing a right
 * click on an item or the viewport of the file manager.
 *
 * Beside static menu entries (e. g. 'Paste' or 'Properties') two
 * dynamic sub menus are shown when opening a context menu above
 * an item:
 * - 'Open With': Contains all applications which are registered to
 *                open items of the given MIME type.
 * - 'Actions':   Contains all actions which can be applied to the
 *                given item.
 *
 *	@author Peter Penz <peter.penz@gmx.at>
 */
class DolphinContextMenu
{
public:
    /**
     * @parent    Pointer to the dolphin view the context menu
     *            belongs to.
     * @fileInfo  Pointer to the file item the context menu
     *            is applied. If 0 is passed, the context menu
     *            is above the viewport.
     * @pos       Position of the upper left edge of the context menu.
     */
    DolphinContextMenu(DolphinView* parent,
                       KFileItem* fileInfo,
                       const QPoint& pos);

    virtual ~DolphinContextMenu();

    /** Opens the context menu modal. */
    void open();

private:
    void openViewportContextMenu();
    void openItemContextMenu();

    /**
     * Returns true, if 'menu' contains already
     * an entry with the name 'entryName'.
     */
    bool containsEntry(const KPopupMenu* menu,
                       const QString& entryName) const;

    DolphinView* m_dolphinView;
    KFileItem* m_fileInfo;
    QPoint m_pos;

    struct Entry {
        int type;
        QString name;
        QString filePath;     // empty for separator
        QString templatePath; // same as filePath for template
        QString icon;
        QString comment;
    };
};

#endif
