import com.tildemh.jgwizard.*;
import org.gnu.gtk.*;
import org.gnu.gtk.event.*;

/**
 * Information regarding bug reporting and Domesday Development
 */
public class BugPage extends WizardPage{

	/**
	 * Constructs a new bug page
	 */
	public BugPage(WizardForm wizard, WizardPage parent){
		super(wizard, parent, DomesdayGUI.messages.getString("BugsTitle"));
	}

	/**
	 * Adds the widgets to the page.
	 */
	protected void customise(){		
		VBox mainVBox = new VBox(false, 5);

		Label titleLbl = new Label(DomesdayGUI.messages.getString("BugTitle"));
		mainVBox.add(titleLbl);
		Label bugTxt = new Label( DomesdayGUI.messages.getString("BugPara"));
		bugTxt.setLineWrap(true);
		mainVBox.add(bugTxt);

		Label devTitle = new Label( DomesdayGUI.messages.getString("DevTitle"));
		mainVBox.add(devTitle);
		Label devPara = new Label( DomesdayGUI.messages.getString("DevPara") );
		devPara.setLineWrap(true);
		mainVBox.add(devPara);

		mainVBox.showAll();
		content =  mainVBox;
		System.out.println("Customised BugPage");
	}

}
