import com.tildemh.jgwizard.*;
import org.gnu.gtk.*;
import org.gnu.glib.*;
import org.gnu.gtk.event.*;
import java.io.IOException;


/**
 * Define output file name and begin the processing stage.
 */
public class StartProcessingPage extends WizardPage{

	/**
	 * 
	 */
	public StartProcessingPage(WizardForm wizard, WizardPage parent){
		super(wizard, parent, DomesdayGUI.messages.getString("StartProcTitle") );
	}


	Entry output;
	
	/**
	 * Constructs the contents of the page.
	 */
	protected void preShow(){
		System.out.println("start processing page preshow.");

		/** Stores the content of the page, to be displayed on the output. */
		VBox mainVBox = new VBox(false, 5);

		Label head = new Label( DomesdayGUI.messages.getString("StartProcOutHead") );
		head.setLineWrap(true);
		mainVBox.packStart(head, false, false, 0);

		output = new Entry();
		try{
			output.setText( DomesdayGUI.project.getStringSetting("OUTPUT_FILENAME") );
		}catch(IllegalVariableException e){
			DomesdayGUI.log.addError(203, "ILLEGAL_VAR_EXCEPTION", new Object[] { e.toString() } );
			e.printStackTrace();
		}
		mainVBox.packStart(output, false, false, 0);

		// TODO: file selection dialog

		Label notes = new Label( DomesdayGUI.messages.getString("StartProcInfo") );
		notes.setLineWrap(true);
		mainVBox.packStart(notes);
		
		setButtonCaptions( DomesdayGUI.messages.getString("Previous"), DomesdayGUI.messages.getString("StartProcNext") );
		setContent(mainVBox);
	}


	/**
	 * Save the settings
	 */
	protected void postShow(){
		System.out.println("save output");
		try{
			DomesdayGUI.project.storeSettingByVar("OUTPUT_FILENAME", output.getText());
		}catch(IllegalVariableException e){
			DomesdayGUI.log.addError(203, "ILLEGAL_VAR_EXCEPTION", new Object[] { e.toString() } );
			e.printStackTrace();
		}
	}

}
