import java.util.*;
import junit.framework.*;


/**
 * Unit test for the Settings class
 *
 * @author Ben Secrest &lt;blsecres@users.sourceforge.net&gt;
 * @version $Id: SettingsTest.java,v 1.3 2002/09/29 05:42:20 blsecres Exp $
 */
public class SettingsTest extends TestCase {
    /** Settings object for English */
    private Settings settings_en;

    /** Settings object for Spansih */
    private Settings settings_es;

    /** Settings object for French */
    private Settings settings_fr;


    /**
     * Initialize objects for testing
     */
    protected void setUp() throws java.io.IOException {
	// at least one other locale
	ResourceBundle rb = ResourceBundle.getBundle("MainStrings",
		Locale.ENGLISH);
	UserInterface ui = new TextInterface(rb, false);
	IGLog log = new IGLog("tests/results/SettingsTest.log", rb, ui);
	settings_en = new Settings(log, Locale.ENGLISH);
	settings_es = new Settings(log, new Locale("es", "mx"));
	settings_fr = new Settings(log, Locale.FRENCH);
    }


    /**
     * Test getTypeByVar
     */
    public void testGetTypeByVar() {
	// language should have no impact on internal representation of
	// variables
	Assert.assertEquals(settings_en.getTypeByVar("SETTINGS_VERSION"),
		Settings.STRING);
	Assert.assertEquals(settings_es.getTypeByVar("GET_METHOD"),
		Settings.ENUM);
	Assert.assertEquals(settings_fr.getTypeByVar("SCAN_INCLUDE_FILTERS"),
		Settings.ARRAY);
	Assert.assertEquals(settings_es.getTypeByVar("CREATED"),
		Settings.INTEGER);
	Assert.assertEquals(settings_fr.getTypeByVar("FOOBAR"), Settings.DNE);
	Assert.assertEquals(settings_en.getTypeByVar(null), Settings.DNE);
    }


    /**
     * Test getTypeByName
     */
    public void testGetTypeByName() {
	Assert.assertEquals(settings_en.getTypeByName("settingsVersion"),
		Settings.STRING);
	Assert.assertEquals(settings_fr.getTypeByName(
		    "nomDeFichierDeRendement"), Settings.STRING);
	Assert.assertEquals(settings_es.getTypeByName("consigaElM\u00e9todo"),
		Settings.ENUM);
	Assert.assertEquals(settings_fr.getTypeByName("obtenezLaM\u00e9thode"),
		Settings.ENUM);
	Assert.assertEquals(settings_en.getTypeByName("ScanIncludeFilters"),
		Settings.ARRAY);
	Assert.assertEquals(settings_es.getTypeByName("archivosACopiar"),
		Settings.ARRAY);
	Assert.assertEquals(settings_en.getTypeByName("created"),
		Settings.INTEGER);
	Assert.assertEquals(settings_fr.getTypeByName("FOOBAR"), Settings.DNE);
	Assert.assertEquals(settings_es.getTypeByName(null), Settings.DNE);
    }


    /**
     * Test getVarByName
     */
    public void testGetVarByName() {
	Assert.assertEquals(settings_en.getVarByName("IndexIncludeFilters"),
		"INDEX_INCLUDE_FILTERS");
	Assert.assertEquals(settings_es.getVarByName("sistemaDeFicheros"),
		"GET_METHOD_FILESYSTEM");
	Assert.assertEquals(settings_fr.getVarByName(
		"rechercheDeSyst\u00e8meDeFichier"), "FILE_SYSTEM_SEARCH");
	Assert.assertEquals(settings_es.getVarByName("jawbreaker"), null);
	Assert.assertEquals(settings_en.getVarByName(null), null);
    }


    /**
     * Test getNameByVar
     */
    public void testGetNameByVar() {
	Assert.assertEquals(settings_en.getNameByVar("OUTPUT_FILENAME"),
		"outputFilename");
	Assert.assertEquals(settings_es.getNameByVar("INDEX_TYPE"),
		"tipoDel\u00cdndice");
	Assert.assertEquals(settings_fr.getNameByVar("INDEX_TYPE_SITE_MAP"),
		"carteD'emplacement");
	Assert.assertEquals(settings_fr.getNameByVar("SHIELD_YOUR_EYES"), null);
	Assert.assertEquals(settings_en.getNameByVar(null), null);
    }


    /**
     * Test validEnumeration
     */
    public void testValidEnumeration() {
	Assert.assertTrue(settings_en.validEnumeration("INDEX_TYPE",
		"INDEX_TYPE_SITE_MAP"));
	Assert.assertFalse(settings_es.validEnumeration("INDEX_TYPE",
		"INDEX_TYPE_EQUALIZED"));
	Assert.assertTrue(settings_fr.validEnumeration("GET_METHOD",
		"GET_METHOD_SERVER"));
	Assert.assertFalse(settings_en.validEnumeration("GET_METHOD",
		"GET_METHOD_CAROLINE"));
	Assert.assertFalse(settings_es.validEnumeration("INDEX_TYPE", null));
	Assert.assertFalse(settings_fr.validEnumeration(null,
		"INDEX_TYPE_SITE_MAP"));
	Assert.assertFalse(settings_en.validEnumeration(null, null));
    }


    /**
     * Test getPlaceHolder
     */
    public void testGetPlaceHolder() {
	Assert.assertEquals(settings_en.getPlaceHolder("PH_GENERATE_DATE"),
		"GenDate");
	Assert.assertEquals(settings_es.getPlaceHolder("PH_DATE_FORMAT"),
		"formato");
	Assert.assertEquals(settings_fr.getPlaceHolder("PH_OUTPUT_FILENAME"),
		"nomDeRendement");
	Assert.assertEquals(settings_en.getPlaceHolder("PH_SPLIT"), null);
	Assert.assertEquals(settings_es.getPlaceHolder(null), null);
    }
}
