# -*- coding: iso-8859-1 -*-
# Copyright (C) 2004-2005 Tristan Seligmann and Jonathan Jacobs
# Copyright (C) 2012-2013 Bastian Kleineidam

from re import compile
from ..scraper import make_scraper
from ..util import tagre


_imageSearch = compile(tagre("img", "src", r'([^"]*/comics/[^"]+)'))
_prevSearch = compile(tagre("a", "href", r'([^"]*/d/\d{8}\.html)') +
   '(?:Previous comic' + '|' +
    tagre("img", "alt", "Previous comic") + '|' +
    tagre("img", "src", "images/back\.gif") +
    ')')

def add(name, url):
    classname = 'KeenSpot_%s' % name
    # XXX all comics are blocked currently by robots.txt :-(
    # disable by prefixing '_' to the classname.
    classname = '_' + classname
    if '/d/' in url:
        stripUrl = url.split('/d/')[0] + '/d/%s.html'
    else:
        stripUrl = url + 'd/%s.html'

    @classmethod
    def _prevUrlModifier(cls, prevUrl):
        if prevUrl:
            return prevUrl.replace("keenspace.com", "comicgenesis.com"
              ).replace("keenspot.com", "comicgenesis.com"
              ).replace("toonspace.com", "comicgenesis.com"
              ).replace("comicgen.com", "comicgenesis.com")

    globals()[classname] = make_scraper(classname,
        name='KeenSpot/' + name,
        url=url,
        stripUrl=stripUrl,
        imageSearch = _imageSearch,
        prevSearch = _prevSearch,
        prevUrlModifier = _prevUrlModifier,
        multipleImagesPerStrip = True,
        help = 'Index format: yyyymmdd',
    )

# All pages are currently blocked by robots.txt, so these comics are not available.

# do not edit anything below since these entries are generated from scripts/update.sh
# DO NOT REMOVE
add('13thLabour', 'http://the13labour.comicgenesis.com/')
add('1999', 'http://mooneytheturtle.comicgenesis.com/')
add('1stcoming', 'http://toon.comicgenesis.com/')
add('21stCenturyCoeds', 'http://twentyfirstcenturycoeds.comicgenesis.com/')
add('21stCenturyFox', 'http://techfox.comicgenesis.com/')
add('2WayMirror', 'http://tande.comicgenesis.com/')
add('AAAAA', 'http://aaaaa.comicgenesis.com/')
add('ABetterLifeThanThis', 'http://abetterlifethanthis.comicgenesis.com/')
add('AKitsuneKotaroStory', 'http://kitsunekotaro.comicgenesis.com/')
add('AStepTooFar', 'http://asoftercore.comicgenesis.com/')
add('ATasteofEvil', 'http://atasteofevil.comicgenesis.com/d/20050314.html')
add('Acalltodestiny', 'http://madgoblin.comicgenesis.com/')
add('Ace147', 'http://ace147.comicgenesis.com/')
add('ActiveStuporHeroes', 'http://stuporheroes.comicgenesis.com/')
add('Adayinthelife', 'http://bangoe23.comicgenesis.com/')
add('Adente', 'http://adente.comicgenesis.com/')
add('AdietheHomicidalManiac', 'http://spiffystuff.comicgenesis.com/')
add('AdventuresInVastia', 'http://aiv.comicgenesis.com/')
add('AdventuresofKiltman', 'http://kiltman.comicgenesis.com/')
add('AdventuresoftheSTeam', 'http://ianthealy.comicgenesis.com/')
add('Aggravation', 'http://aggravation.comicgenesis.com/')
add('AinoYasha', 'http://ainoyasha.comicgenesis.com/')
add('AllAboutEda', 'http://aae.comicgenesis.com/')
add('AllRosesHaveThorns', 'http://allroses.comicgenesis.com/')
add('AllWishes', 'http://allwishes.comicgenesis.com/')
add('AlphaBetaSoup', 'http://abs.comicgenesis.com/')
add('AlphaLuna', 'http://alphaluna.comicgenesis.com/')
add('AlternateDelusions', 'http://altdelusions.comicgenesis.com/')
add('AmazonSpaceRangers', 'http://amazons.comicgenesis.com/d/20051015.html')
add('Amhelakimisadventures', 'http://amhelaki.comicgenesis.com/')
add('AmorModerno', 'http://amormoderno.comicgenesis.com/')
add('AndShineHeavenNow', 'http://hellsing.comicgenesis.com/')
add('Andellon', 'http://andellon.comicgenesis.com/')
add('AneirinsDen', 'http://aden.comicgenesis.com/')
add('AngelBlood', 'http://angelblood.comicgenesis.com/')
add('AngelWarriorComics', 'http://angelwarriorcomics.comicgenesis.com/')
add('AngryPeople', 'http://angrypeople.comicgenesis.com/')
add('AngrySoul', 'http://angrysoul.comicgenesis.com/')
add('AnimalInstinct', 'http://animalinstinct.comicgenesis.com/')
add('AnimeMomentsinHistory', 'http://animehistory.comicgenesis.com/')
add('AnthropomorphicHardware', 'http://hardware.comicgenesis.com/')
add('AntiBunny', 'http://www.antibunny.com/')
add('AntiChristDaiji', 'http://clad.comicgenesis.com/')
add('AntiZombieArmy', 'http://antizombiearmy.comicgenesis.com/')
add('Antifeline', 'http://antifeline.comicgenesis.com/')
add('AnythingBut', 'http://anythingbut.comicgenesis.com/')
add('AnythingButRealLife', 'http://anythingbutreallife.comicgenesis.com/')
add('AnywhereButHere', 'http://anywherebuthere.comicgenesis.com/')
add('ApocHigh', 'http://apochigh.comicgenesis.com/')
add('Apotheosis', 'http://apotheosis.comicgenesis.com/')
add('Ardra', 'http://ardra.comicgenesis.com/')
add('ArkkanysChibiTheater', 'http://arkkanystheater.comicgenesis.com/')
add('ArnieGattonGalleryofComics', 'http://agallery.comicgenesis.com/')
add('ArroganceinSimplicity', 'http://arrogance.comicgenesis.com/d/20030217.html')
add('ArtificialTime', 'http://artificialtime.comicgenesis.com/')
add('Artwork', 'http://artwork.comicgenesis.com/')
add('AscendingHeaven', 'http://ascendingheaven.comicgenesis.com/')
add('Asianosity', 'http://asianosity.comicgenesis.com/')
add('AssO9Tails', 'http://asso9tails.comicgenesis.com/')
add('AsylumHeights', 'http://asylumheights.comicgenesis.com/')
add('Avalon', 'http://avalon.comicgenesis.com/')
add('BabeintheWoods', 'http://babeinthewoods.comicgenesis.com/')
add('BackwaterPlanet', 'http://bobthespirit.comicgenesis.com/')
add('BallofYarn', 'http://ballofyarn.comicgenesis.com/d/20020624.html')
add('Balls', 'http://balls.comicgenesis.com/')
add('BearCatBummers', 'http://bearcatbummers.comicgenesis.com/')
add('BeautifulSkies', 'http://bskies.comicgenesis.com/')
add('BebsinVideogameLand', 'http://videogame.comicgenesis.com/')
add('BecauseofMathClass', 'http://mathclass.comicgenesis.com/')
add('Beerkada', 'http://beerkada.comicgenesis.com/')
add('BeforeDawn', 'http://beforedawn.comicgenesis.com/')
add('BendyStrawVampires', 'http://bsvampires.comicgenesis.com/')
add('BetatheStrip', 'http://strangefour.comicgenesis.com/')
add('BetweenRealities', 'http://realities.comicgenesis.com/')
add('BeyondtheRadiator', 'http://radiator.comicgenesis.com/')
add('Bhag', 'http://bhag.comicgenesis.com/')
add('BigTom', 'http://bigtom.comicgenesis.com/')
add('Bikou', 'http://bikou.comicgenesis.com/')
add('BishoujoKishiSailorHellsing', 'http://sailorhellsing.comicgenesis.com/')
add('BishounenHunters', 'http://bishihunters.comicgenesis.com/')
add('BitterSweetBS', 'http://bsbs.comicgenesis.com/')
add('BlackTapestries', 'http://blacktapestries.comicgenesis.com/')
add('Blackaby', 'http://blackaby.comicgenesis.com/')
add('Blahsville', 'http://blahsville.comicgenesis.com/')
add('BlankGeorge', 'http://blankgeorge.comicgenesis.com/')
add('Blatah', 'http://blatah.comicgenesis.com/')
add('BleistiftAnsatzSissy', 'http://bleistiftansatz.comicgenesis.com/')
add('BlindSight', 'http://blindsight.comicgenesis.com/')
add('BloeCloudedNinja', 'http://bloeninja.comicgenesis.com/')
add('Bloodofthedragon', 'http://bdragon.comicgenesis.com/')
add('BlottoStreet', 'http://blottostreet.comicgenesis.com/')
add('BlueCollarCleanup', 'http://franko.comicgenesis.com/')
add('BlueSkunkthewebcomic', 'http://freakofnature.comicgenesis.com/')
add('BlueandOrange', 'http://blueandorange.comicgenesis.com/')
add('Blunderclod', 'http://blunderclod.comicgenesis.com/')
add('BoB', 'http://ymmot.comicgenesis.com/')
add('BobNEd', 'http://bobned.comicgenesis.com/')
add('BoldStyle', 'http://boldstyle.comicgenesis.com/')
add('BondsofBlood', 'http://bondsofblood.comicgenesis.com/')
add('BoobsAhoy', 'http://boobsahoy.comicgenesis.com/')
add('Bookwyrms', 'http://bookwyrms.comicgenesis.com/')
add('BorderlineSanity', 'http://brdrline.comicgenesis.com/')
add('Brainfries', 'http://www.brainfries.com/')
add('BreakingtheDoldrum', 'http://breakingthedoldrum.comicgenesis.com/')
add('BreckenChronicles', 'http://brecken.comicgenesis.com/')
add('BridgettesBelly', 'http://bridgette.comicgenesis.com/')
add('BrightSpark', 'http://brightspark.comicgenesis.com/')
add('BrokenGlass', 'http://brokenglass.comicgenesis.com/')
add('BrokenWorlds', 'http://brokenworlds.comicgenesis.com/')
add('Brunswick', 'http://brunswick.comicgenesis.com/')
add('BubbaandAlice', 'http://bubba.comicgenesis.com/')
add('CAGE', 'http://cage.comicgenesis.com/')
add('CTRO', 'http://llv.comicgenesis.com/')
add('CUltureShocked', 'http://kitsune76.comicgenesis.com/')
add('CameoComic', 'http://cameocomic.comicgenesis.com/')
add('CampAlaska', 'http://campalaska.comicgenesis.com/')
add('CampusLife', 'http://campuslife.comicgenesis.com/')
add('CanYouKeepaSecret', 'http://cykas.comicgenesis.com/d/20041035.html')
add('Candi', 'http://candicomics.com/')
add('CanisLupus', 'http://cheetahfox.comicgenesis.com/')
add('Capn', 'http://capn.comicgenesis.com/')
add('CaptainGreyhound', 'http://captaingreyhound.comicgenesis.com/')
add('CaptainMike', 'http://captainmike.comicgenesis.com/')
add('CaptainSNES', 'http://captainsnes.comicgenesis.com/')
add('CaptainSuppository', 'http://suppository.comicgenesis.com/')
add('CarameledSugar', 'http://carameledsugar.comicgenesis.com/')
add('Carnivores', 'http://carnivores.comicgenesis.com/')
add('CarriedbytheWind', 'http://carried.comicgenesis.com/')
add('CascadeFailure', 'http://cascadefailure.comicgenesis.com/')
add('CatboyattheCon', 'http://trades.comicgenesis.com/')
add('Catscradle', 'http://catscradle.comicgenesis.com/')
add('Chainroaker', 'http://chainroaker.comicgenesis.com/')
add('ChaosInc', 'http://chaosinc.comicgenesis.com/')
add('ChaosKnot', 'http://chaosknot.comicgenesis.com/')
add('ChaosRPG', 'http://chaosrpg.comicgenesis.com/')
add('Chicanery', 'http://chicanery.comicgenesis.com/')
add('Choukousei', 'http://choukousei.comicgenesis.com/')
add('ChrissCollectionofCrappyComix', 'http://chrisread.comicgenesis.com/')
add('ChronicMisadventures', 'http://chronic.comicgenesis.com/')
add('ChubbyandNot', 'http://chubbyandnot.comicgenesis.com/')
add('Cinderblock', 'http://cinderblock.comicgenesis.com/')
add('Citron', 'http://citron.comicgenesis.com/')
add('CitrusHouse', 'http://citrushouse.comicgenesis.com/')
add('ClearwaterClan', 'http://clearwaterclan.comicgenesis.com/')
add('Clematis', 'http://clematis.comicgenesis.com/')
add('ClippedWings', 'http://clippedwings.comicgenesis.com/')
add('ClosetOddity', 'http://closetoddity.comicgenesis.com/')
add('CodeRage', 'http://coderage.comicgenesis.com/')
add('Codename9', 'http://codename9.comicgenesis.com/')
add('ColdPlanet', 'http://coldplanet.comicgenesis.com/')
add('Collidingworlds', 'http://fearunianadv.comicgenesis.com/')
add('Colour', 'http://colour.comicgenesis.com/')
add('ComicLikeHell', 'http://comiclikehell.comicgenesis.com/')
add('Comicollage', 'http://comicollage.comicgenesis.com/')
add('Comowilemdurniu', 'http://cmd.comicgenesis.com/')
add('ConfessionsofanEnglishCatburglar', 'http://catburglars.comicgenesis.com/')
add('Conned', 'http://con.comicgenesis.com/')
add('ConstantFlux', 'http://constantflux.comicgenesis.com/')
add('Cooties', 'http://cooties.comicgenesis.com/')
add('CornerAlley13', 'http://corneralley.comicgenesis.com/d/20101010.html')
add('CorporateLife', 'http://amacher.comicgenesis.com/')
add('CosmicAwareness', 'http://cosmicawareness.comicgenesis.com/')
add('CosmicDrift', 'http://cosmicdrift.comicgenesis.com/')
add('CracklingSilence', 'http://crackling.comicgenesis.com/')
add('Crackwalker', 'http://crackwalker.comicgenesis.com/')
add('CreepyHead', 'http://creepyhead.comicgenesis.com/')
add('CrookedHalo', 'http://chaoscricket.comicgenesis.com/')
add('CrossStreetBlues', 'http://crossstreet.comicgenesis.com/')
add('CrossroadsOfBoogerCounty', 'http://cobc.comicgenesis.com/')
add('CryHavoc', 'http://cryhavoc.comicgenesis.com/')
add('CuteThulhu', 'http://www.cutethulhu.com/')
add('DBZRPGTheComic', 'http://dbzrpg.comicgenesis.com/')
add('DanskFolly', 'http://danskfolly.comicgenesis.com/')
add('DarkKnight', 'http://dk.comicgenesis.com/')
add('DarkSneakers', 'http://darksneakers.comicgenesis.com/')
add('DarkWelkin', 'http://darkwelkin.comicgenesis.com/')
add('Dasien', 'http://www.dasiencomic.com/')
add('DataChasers', 'http://datachasers.comicgenesis.com/')
add('DavidandJohn', 'http://davidandjohn.comicgenesis.com/')
add('DavidsCrappyArt', 'http://earth.comicgenesis.com/')
add('DayintheLifeofaCosplayer', 'http://ditloac.comicgenesis.com/')
add('DeViations', 'http://dirkdancer.comicgenesis.com/')
add('DeadEndStudios', 'http://deadendstudios.comicgenesis.com/')
add('DeadlyAngels', 'http://deadlyangels.comicgenesis.com/')
add('DecorativeEdison', 'http://dece.comicgenesis.com/')
add('DedEnd', 'http://dedend.comicgenesis.com/')
add('Delinquents', 'http://delinquents.comicgenesis.com/')
add('DemonEater', 'http://demoneater.comicgenesis.com/')
add('DemonicBoppu', 'http://demonicboppu.comicgenesis.com/')
add('DemoralizedLogic', 'http://lostmind.comicgenesis.com/')
add('DepthDefyingAdventuresofCaptNemo', 'http://captnemo.comicgenesis.com/')
add('Desolationangeltango', 'http://desolationangel.comicgenesis.com/')
add('DetFemteEss', 'http://haykay.comicgenesis.com/')
add('DexLives', 'http://dexlives.comicgenesis.com/')
add('DigitalAge', 'http://digitalage.comicgenesis.com/')
add('Dindsneys', 'http://xxxx.comicgenesis.com/')
add('DinoandSam', 'http://dinoandsam.comicgenesis.com/')
add('DirkCrimsonEightBitDetective', 'http://dirkcrimson.comicgenesis.com/')
add('DirtySocks', 'http://dirtysocks.comicgenesis.com/')
add('DogDays', 'http://dogdays.comicgenesis.com/')
add('DogandPony', 'http://dogandpony.comicgenesis.com/')
add('DogtheSpot', 'http://dogthespot.comicgenesis.com/')
add('DominicDurgan', 'http://dominicdurgan.comicgenesis.com/')
add('DonutKitty', 'http://donutkitty.comicgenesis.com/')
add('DoodleDiaries', 'http://doodlediaries.comicgenesis.com/')
add('DoomedUntoEternalVigilanceForever', 'http://duevf.comicgenesis.com/')
add('DormSweetDorm', 'http://dormsweetdorm.comicgenesis.com/')
add('DoubleyouTeeEff', 'http://doubleyouteeeff.comicgenesis.com/')
add('Downscale', 'http://downscale.comicgenesis.com/')
add('DragonBallTM', 'http://dragonballtm.comicgenesis.com/')
add('DragonBoy', 'http://dragonboy.comicgenesis.com/')
add('DragonKingdoms', 'http://dragonkingdoms.comicgenesis.com/')
add('Dragonaur', 'http://dragonaur.comicgenesis.com/')
add('DragonintheCourtyard', 'http://ditc.comicgenesis.com/')
add('DragonsBane', 'http://jasonwhitewaterz.comicgenesis.com/')
add('DragonstarComics', 'http://www.fogclub.net/')
add('DramaClub', 'http://dramaclub.comicgenesis.com/')
add('DrawingTheLine', 'http://drawingtheline.comicgenesis.com/')
add('DreamWay', 'http://dreamway.comicgenesis.com/')
add('Dreamaniac', 'http://dreamaniaccomic.comicgenesis.com/')
add('DreamersDynasty', 'http://kidneo66.comicgenesis.com/')
add('DreamofaWorld', 'http://doaw.comicgenesis.com/')
add('Drewford', 'http://drewford.comicgenesis.com/')
add('DrunkMonkeyComicsPresents', 'http://drunkmonkey.comicgenesis.com/')
add('DysfunctionJunction', 'http://dysfunctionjunction.comicgenesis.com/')
add('DysonsCreek', 'http://dysonscreek.comicgenesis.com/')
add('E2', 'http://e2e.comicgenesis.com/')
add('ECWorldofFenninRo', 'http://wofr.comicgenesis.com/')
add('ESHbyESH', 'http://esh.comicgenesis.com/')
add('EarlandMyrtle', 'http://earlandmyrtle.comicgenesis.com/')
add('EastLyme', 'http://airdeck007.comicgenesis.com/')
add('Eggbert', 'http://eggbert.comicgenesis.com/')
add('EinstiensDesk', 'http://einstiensdesk.comicgenesis.com/')
add('ElementsSong', 'http://zina.comicgenesis.com/')
add('ElfMadness', 'http://elfmadness.comicgenesis.com/')
add('ElnifiChronicles', 'http://elnifichronicles.comicgenesis.com/')
add('ElvenFate', 'http://elvenfate.comicgenesis.com/')
add('Emma', 'http://miruku.comicgenesis.com/')
add('EmperorofOrphans', 'http://emperoroforphans.comicgenesis.com/')
add('EndlessLimit', 'http://endlesslimit.comicgenesis.com/')
add('Epigenesis', 'http://epigenesis.comicgenesis.com/')
add('ErrorLevel3', 'http://errorboy.comicgenesis.com/')
add('EscapemanAdventures', 'http://escapeman.comicgenesis.com/')
add('Etch', 'http://etch.comicgenesis.com/')
add('EvesApple', 'http://evesapple.comicgenesis.com/')
add('EvilNeedsCandyToo', 'http://evilneedscandytoo.comicgenesis.com/')
add('EvilOverlordsUnited', 'http://eou.comicgenesis.com/')
add('EvilWenchesIncorporated', 'http://evilwenchesinc.comicgenesis.com/')
add('EyeoftheMonkey', 'http://eyeofthemonkey.comicgenesis.com/')
add('Ezailia', 'http://ezailia.comicgenesis.com/')
add('Faces', 'http://faces.comicgenesis.com/')
add('Fagz', 'http://fagz.comicgenesis.com/')
add('FakingSanity', 'http://fakingsanity.comicgenesis.com/')
add('Fallinglessons', 'http://fallinglessons.comicgenesis.com/')
add('FalseGods', 'http://falsegod.comicgenesis.com/')
add('FancyThat', 'http://fancythat.comicgenesis.com/')
add('FanserviceMeteorologyWin', 'http://aod.comicgenesis.com/')
add('FantasyQwest', 'http://creatorauthorman.comicgenesis.com/')
add('FarchieArchie', 'http://farchie.comicgenesis.com/')
add('Farmboy', 'http://farmboy.comicgenesis.com/')
add('FatesTear', 'http://firecloud.comicgenesis.com/')
add('FearfulAsymptote', 'http://fearful.comicgenesis.com/')
add('FellowFreaks', 'http://fellowfreaks.comicgenesis.com/')
add('Felney', 'http://felneycomic.comicgenesis.com/')
add('FemmeFatale', 'http://femmefatale.comicgenesis.com/')
add('FeverDream', 'http://feverdream.comicgenesis.com/')
add('FiddlyBits', 'http://fiddlybits.comicgenesis.com/')
add('FightCastorEvade', 'http://fightcastorevade.comicgenesis.com/')
add('FilmFunnies', 'http://filmfunnies.comicgenesis.com/')
add('FinalDraft', 'http://finaldraft.comicgenesis.com/')
add('FireflyCross', 'http://fireflycross.comicgenesis.com/')
add('FiveMinuteComic', 'http://fiveminute.comicgenesis.com/')
add('Fizzle', 'http://fizzle.comicgenesis.com/')
add('FlinchandFriends', 'http://flinch.comicgenesis.com/')
add('Flounderville', 'http://flounderville.comicgenesis.com/')
add('FloydCartoons', 'http://floydcartoons.comicgenesis.com/')
add('Flunkies', 'http://flunkies.comicgenesis.com/')
add('Flux', 'http://flux.comicgenesis.com/')
add('Flyinghighandlow', 'http://highandlow.comicgenesis.com/')
add('FnK', 'http://fnk.comicgenesis.com/')
add('FollowTheLeaderAndTurnip', 'http://jadesche.comicgenesis.com/')
add('Foma', 'http://foma.comicgenesis.com/')
add('FoolsGold', 'http://foolsgold.comicgenesis.com/')
add('Footballman', 'http://footballman.comicgenesis.com/')
add('ForfeitZero', 'http://forfeitzero.comicgenesis.com/')
add('FortheLoveofYaoi', 'http://fortheloveofyaoi.comicgenesis.com/')
add('FourDays', 'http://fourdays.comicgenesis.com/')
add('Fourboys', 'http://fourboys.comicgenesis.com/')
add('FoxTails', 'http://foxtails.comicgenesis.com/')
add('FoxsFreakyAdventures', 'http://basa.comicgenesis.com/')
add('FreakU', 'http://freaku.comicgenesis.com/d/20080827.html')
add('FreaksandG33k', 'http://freaksandgeeks.comicgenesis.com/')
add('FredtheDot', 'http://fredthedot.comicgenesis.com/')
add('FreeParking', 'http://freeparking.comicgenesis.com/d/20051029.html')
add('FromTheAntiCulture', 'http://anticulture.comicgenesis.com/')
add('FromTheMargin', 'http://fromthemargin.comicgenesis.com/')
add('Fromthedeskof', 'http://fromthedeskof.comicgenesis.com/')
add('FruitFlies', 'http://fruitflies.comicgenesis.com/')
add('FunwithPants', 'http://funwithpants.comicgenesis.com/')
add('Furmentation', 'http://xodin.comicgenesis.com/')
add('FurthiaHigh', 'http://furthiahigh.comicgenesis.com/')
add('FyshbowlComics', 'http://fysh.comicgenesis.com/')
add('GalacticAcademy', 'http://galacticacademy.comicgenesis.com/')
add('GambitasBishounen', 'http://snigepippi.comicgenesis.com/')
add('GameJumpers', 'http://gamejumpers.comicgenesis.com/')
add('GameMisconduct', 'http://gmhockey.comicgenesis.com/')
add('Gameboy', 'http://gameboy.comicgenesis.com/')
add('GamersParadox', 'http://gamersparadox.comicgenesis.com/')
add('GamingGuardians', 'http://gamingguardians.comicgenesis.com/')
add('GamingReality', 'http://gamingreality.comicgenesis.com/')
add('Gao', 'http://gao.comicgenesis.com/')
add('Gemini', 'http://gemini.comicgenesis.com/')
add('GenerationDumb', 'http://generationdumb.comicgenesis.com/')
add('GhastlysGhastlyComic', 'http://www.ghastlycomic.com/')
add('GlamourLust', 'http://glamourlust.comicgenesis.com/')
add('GlickGlidewell', 'http://glickglidewell.comicgenesis.com/')
add('Gnerds2000', 'http://gnerds.comicgenesis.com/')
add('Gnomes', 'http://gnomes.comicgenesis.com/')
add('GoCrazy', 'http://gocrazy.comicgenesis.com/')
add('GoFish', 'http://gofish.comicgenesis.com/')
add('GodtheDevilandaMonkey', 'http://godthedevilandamonkey.comicgenesis.com/')
add('GoldenAge', 'http://goldenage.comicgenesis.com/')
add('GoneAstray', 'http://goneastray.comicgenesis.com/d/20100305.html')
add('Gonefor300days', 'http://g4300d.comicgenesis.com/')
add('GoodnEvil', 'http://gne.comicgenesis.com/d/20040814.html')
add('GorgeousPrincessCreamyBeamy', 'http://creamybeamy.comicgenesis.com/')
add('GothyMcGee', 'http://gothymcgee.comicgenesis.com/')
add('GratuitousMangaStyle', 'http://mangastyle.comicgenesis.com/')
add('GraveyardShift', 'http://graveyardshift.comicgenesis.com/')
add('GreenLightGo', 'http://glg.comicgenesis.com/')
add('GroundFloor', 'http://groundfloor.comicgenesis.com/')
add('Grumpythefathamster', 'http://burp.comicgenesis.com/')
add('GuiShinTaeChiAKAGhostHunter', 'http://ghosthunter.comicgenesis.com/')
add('HERZBLUT', 'http://herzblut.comicgenesis.com/')
add('HangingAround', 'http://hangingaround.comicgenesis.com/')
add('Hans', 'http://hans.comicgenesis.com/')
add('HaypennyRag', 'http://haypenny.comicgenesis.com/')
add('HazardsWake', 'http://hazardswake.comicgenesis.com/')
add('HbombsBrandNewComic', 'http://hbombshow.comicgenesis.com/')
add('HeadDoctorProductions', 'http://headdoctor.comicgenesis.com/')
add('HealerOnFeatheredWings', 'http://selsachronicles.comicgenesis.com/')
add('HeartofaDragon', 'http://heartofadragon.comicgenesis.com/')
add('Hedgehogs', 'http://hedgehogs.comicgenesis.com/')
add('HellSweetHell', 'http://hellsweethell.comicgenesis.com/')
add('Hepcats', 'http://hepcats.comicgenesis.com/')
add('HeroAcademy', 'http://heroacademy.comicgenesis.com/')
add('HeroAndapossGuild', 'http://herosguild.comicgenesis.com/')
add('HeroInTraining', 'http://thereisnosaurus.comicgenesis.com/')
add('HeyFox', 'http://heyfox.comicgenesis.com/')
add('Heysuburbia', 'http://rockyfoxtop.comicgenesis.com/')
add('Hiakuma', 'http://hiakuma.comicgenesis.com/')
add('HitoTsukitoHoshinoTama', 'http://htht.comicgenesis.com/')
add('HoleintheWall', 'http://holeinthewall.comicgenesis.com/')
add('HomeFries', 'http://friedgreencomics.comicgenesis.com/')
add('HoosierDaddy', 'http://hoosiermorons.comicgenesis.com/')
add('HorriblyOldSchoolSuperFightFight', 'http://superfightfight.comicgenesis.com/')
add('HouseofBob', 'http://dustbunny.comicgenesis.com/')
add('HowISeeIt', 'http://toasterpip.comicgenesis.com/')
add('HowNottoRunAComic', 'http://hownottorunacomic.comicgenesis.com/d/19950719.html')
add('HowtoCookaSpasticChicken', 'http://wench.comicgenesis.com/')
add('HurricaneParty', 'http://hurricaneparty.comicgenesis.com/d/20040123.html')
add('Hyperboy', 'http://hyperboy.comicgenesis.com/')
add('Hyperghostbroadcasts', 'http://hyperghostbroadcasts.comicgenesis.com/')
add('Hypnoholic', 'http://hypnoholic.comicgenesis.com/')
add('IBlameDanny', 'http://vileterror.comicgenesis.com/')
add('IDGet', 'http://idget.comicgenesis.com/')
add('IDITS', 'http://idiots.comicgenesis.com/')
add('IEatFood', 'http://ieatfood.comicgenesis.com/')
add('IamMacdoogle', 'http://americana.comicgenesis.com/')
add('IdleMinds', 'http://idleminds.comicgenesis.com/')
add('Ifeeltwitchy', 'http://meghasissues.comicgenesis.com/')
add('Ifthenelse', 'http://ifthenelse.comicgenesis.com/')
add('Ihopeyoualldie', 'http://ihateyou.comicgenesis.com/')
add('InANutshell', 'http://nutshellcomics.comicgenesis.com/')
add('InSearchofHappyEndings', 'http://isohe.comicgenesis.com/')
add('InSpriteOfTheFaqs', 'http://inspriteofthefaqs.comicgenesis.com/')
add('InTransit', 'http://squazzy.comicgenesis.com/')
add('InappropriateIrving', 'http://irving.comicgenesis.com/')
add('Inconsistentshorts', 'http://ics.comicgenesis.com/')
add('InfiniteSouls', 'http://keyoko.comicgenesis.com/')
add('InkyorShaggy', 'http://inkyorshaggy.comicgenesis.com/')
add('IntergalacticSpaceSheriffs', 'http://spacesheriffs.comicgenesis.com/')
add('IpsoFacto', 'http://ipsofactocomic.comicgenesis.com/')
add('ItHurtsToBeThatStupid', 'http://ihtbts.comicgenesis.com/')
add('ItsGravy', 'http://itsgravy.comicgenesis.com/')
add('JAndSOddjobs', 'http://oddworld.comicgenesis.com/')
add('JRockShellShock', 'http://jrock.comicgenesis.com/')
add('JackSplat', 'http://jacksplat.comicgenesis.com/')
add('JackiesFridge', 'http://jackiesfridge.comicgenesis.com/')
add('JagerRising', 'http://jinoku.comicgenesis.com/')
add('JapanimationFist', 'http://japanimationfist.comicgenesis.com/')
add('Jersey', 'http://jersey.comicgenesis.com/')
add('JeuDeVivre', 'http://gameoflife.comicgenesis.com/')
add('JimTheVikingTheUnanimatedSeries', 'http://jtv.comicgenesis.com/')
add('Jirale', 'http://jirale.comicgenesis.com/')
add('Jitterati', 'http://jitterati.comicgenesis.com/')
add('JoeandPip', 'http://joeandpip.comicgenesis.com/')
add('JonesAvenue', 'http://jonesave.comicgenesis.com/')
add('JourneysDown', 'http://journeys.comicgenesis.com/')
add('JulyStreet', 'http://julystreet.comicgenesis.com/')
add('JunkRIOT', 'http://junkriot.comicgenesis.com/')
add('KariandDoug', 'http://karindoug.comicgenesis.com/')
add('Kazei5Rebirth', 'http://whiterabbit.comicgenesis.com/')
add('KeatonandCompany', 'http://keaton.comicgenesis.com/')
add('Kelen', 'http://kelen.comicgenesis.com/')
add('KernyMantisComics', 'http://kernymantis.comicgenesis.com/')
add('Khaoskomic', 'http://komix.comicgenesis.com/')
add('KiagiSwordscat', 'http://kiagi.comicgenesis.com/')
add('KidsStuff', 'http://kidsstuff.comicgenesis.com/')
add('KindaLikeReality', 'http://klr.comicgenesis.com/')
add('KissthePan', 'http://kissthepan.comicgenesis.com/')
add('KitnKayBoodle', 'http://kitnkayboodle.comicgenesis.com/')
add('KitsuneJewel', 'http://kitsunejewel.comicgenesis.com/')
add('KittyCattyGames', 'http://kittycattygames.comicgenesis.com/')
add('KiwiDay', 'http://kiwiday.comicgenesis.com/')
add('KiwiDayN', 'http://kiwidayn.comicgenesis.com/')
add('KnightsoftheOldCoding', 'http://kotoc.comicgenesis.com/')
add('KodomoNomo', 'http://kodomonomo.comicgenesis.com/')
add('Kokiro', 'http://kokiro.comicgenesis.com/')
add('KungFounded', 'http://kungfounded.comicgenesis.com/')
add('KungFuPandas', 'http://kungfupandas.comicgenesis.com/')
add('KurenaiMashin', 'http://km.comicgenesis.com/')
add('LCDLowestCommonDenominator', 'http://lcd.comicgenesis.com/')
add('LXFTheLeagueofExtraordinaryFurries', 'http://lxfurries.comicgenesis.com/')
add('LaMouettetheseagullfromMars', 'http://lamouette.comicgenesis.com/')
add('LabBratz', 'http://labbratz.comicgenesis.com/')
add('Lacunae', 'http://lacunae.comicgenesis.com/')
add('LangLang', 'http://langlang.comicgenesis.com/')
add('LarryandOliver', 'http://lao.comicgenesis.com/')
add('Laserwing', 'http://laserwing.comicgenesis.com/')
add('LatentIntent', 'http://latentintent.comicgenesis.com/')
add('Leapingwizards', 'http://leapingwizards.comicgenesis.com/')
add('LegendOfTheFour', 'http://legendoffour.comicgenesis.com/')
add('LegendaryMagicalAngelPrincessCeleste', 'http://celeste.comicgenesis.com/')
add('LegendoftheGalaxyWar', 'http://galaxylegend.comicgenesis.com/')
add('Leo', 'http://leoninecomics.comicgenesis.com/')
add('LetThereBeLight', 'http://ltbl.comicgenesis.com/')
add('LeuandYar', 'http://leunam12.comicgenesis.com/')
add('LifeGoesOn', 'http://lgo.comicgenesis.com/')
add('LifeinBellCounty', 'http://bellcountylife.comicgenesis.com/')
add('LifeisUnfair', 'http://lifeisunfair.comicgenesis.com/')
add('LifeofBuddha', 'http://lifeofbuddha.comicgenesis.com/')
add('LifesaWitch', 'http://lifesawitch.comicgenesis.com/')
add('Lightbringer', 'http://lightbringer.comicgenesis.com/')
add('LikeItIs', 'http://likeitis.comicgenesis.com/')
add('LilDude', 'http://lildudecomics.comicgenesis.com/')
add('LilFAS', 'http://lilfas.comicgenesis.com/')
add('LilianeBiDyke', 'http://liliane.comicgenesis.com/')
add('LineGuy', 'http://lineguy.comicgenesis.com/')
add('Linnyanie', 'http://linnyanie.comicgenesis.com/')
add('LittleSaiyalings', 'http://saiyalings.comicgenesis.com/')
add('LobbyGirlsHaveAReputation', 'http://lobbygirls.comicgenesis.com/')
add('Loserz', 'http://loserzcomic.comicgenesis.com/')
add('LostinTransit', 'http://lostintransit.comicgenesis.com/')
add('LostinTranslation', 'http://lit.comicgenesis.com/')
add('LoveBites', 'http://lovebites.comicgenesis.com/')
add('LoveMeNot', 'http://lovemenot.comicgenesis.com/')
add('LowerPlace', 'http://lowerplace.comicgenesis.com/')
add('LumiasKingdom', 'http://lumia.comicgenesis.com/')
add('LunchTime', 'http://lunchtime.comicgenesis.com/')
add('LustForFreelance', 'http://imabubble.comicgenesis.com/')
add('MEHComics', 'http://mehcomics.comicgenesis.com/')
add('MORONS', 'http://morons.comicgenesis.com/')
add('MTranc3', 'http://mtranc3.comicgenesis.com/')
add('Maddland', 'http://maddland.comicgenesis.com/')
add('MadeInHeaven', 'http://mih.comicgenesis.com/')
add('MagiIndustries', 'http://magiindustries.comicgenesis.com/')
add('MahouShoujoerUsagi', 'http://usagi.comicgenesis.com/')
add('Majestic7', 'http://majestic7.comicgenesis.com/')
add('ManicGraffiti', 'http://manic.comicgenesis.com/')
add('ManorJam', 'http://manorjam.comicgenesis.com/')
add('MarchingToADifferentAccordion', 'http://accordion.comicgenesis.com/')
add('MaryQuiteContrary', 'http://marycontrary.comicgenesis.com/d/20070824.html')
add('MasterMizzysHappyHorribleMutantMachine', 'http://megarose.comicgenesis.com/')
add('MaximumWhimsy', 'http://maximumwhimsy.comicgenesis.com/')
add('McDuffies', 'http://mcduffies.comicgenesis.com/')
add('McVille', 'http://mcville.comicgenesis.com/')
add('MechagicalGirlLisaANT', 'http://ant.comicgenesis.com/')
add('Mediocregothboi', 'http://gothboi.comicgenesis.com/')
add('MeetTheDweebles', 'http://dweebles.comicgenesis.com/')
add('MegaCool', 'http://megacool.comicgenesis.com/')
add('MelEverymanAndHisSarcasticTalkingHousepetAmbrose', 'http://everyman.comicgenesis.com/')
add('MenschunsererZeitGerman', 'http://muz.comicgenesis.com/')
add('Midcentral', 'http://midcentral.comicgenesis.com/')
add('MiketheMulletThing', 'http://mikethemulletthing.comicgenesis.com/')
add('Mindtap', 'http://mindtap.comicgenesis.com/')
add('MinimalismSucks', 'http://minisuck.comicgenesis.com/')
add('MinimumSecurityUniversity', 'http://mshs.comicgenesis.com/')
add('MisadventuresoftheDrowWizard', 'http://motdw.comicgenesis.com/')
add('MixedMyth', 'http://mixedmyth.comicgenesis.com/')
add('ModelStudent', 'http://darkmaxtor.comicgenesis.com/')
add('MolluskAntics', 'http://molluskantics.comicgenesis.com/')
add('Monkey', 'http://monkey.comicgenesis.com/')
add('MoonCrest24', 'http://mooncrest.comicgenesis.com/d/20121117.html')
add('MorganintheMorning', 'http://mitm.comicgenesis.com/')
add('MorysEducation', 'http://mory.comicgenesis.com/')
add('MrBoffleandFriends', 'http://mrboffle.comicgenesis.com/')
add('MrBubbles', 'http://profound.comicgenesis.com/')
add('MrFooAdventures', 'http://foo.comicgenesis.com/')
add('MrScience', 'http://mrscience.comicgenesis.com/')
add('Mtheory', 'http://mtheory.comicgenesis.com/')
add('Muertitos', 'http://muertitos.comicgenesis.com/')
add('Muffythelitlerabbit', 'http://muffyrabbit.comicgenesis.com/')
add('MugenAnime', 'http://mugen.comicgenesis.com/')
add('MugenCrosswires', 'http://mugencrosswires.comicgenesis.com/')
add('Mushian', 'http://tentoumushi.comicgenesis.com/')
add('Mutant59', 'http://wrathofautumn.comicgenesis.com/')
add('MyLifeinBlue', 'http://mylifeinblue.comicgenesis.com/')
add('MysteryCastle', 'http://mysterycastle.comicgenesis.com/')
add('MysticRevolution', 'http://mysticrevolution.comicgenesis.com/')
add('MythocorpIntl', 'http://mythocorp.comicgenesis.com/')
add('NKatz', 'http://nkatz.comicgenesis.com/')
add('NahastLandsofStrife', 'http://nahast.comicgenesis.com/')
add('NardManga', 'http://nardmanga.comicgenesis.com/')
add('NastyChocolates', 'http://nastychocolates.comicgenesis.com/')
add('NeTrek', 'http://netrek.comicgenesis.com/')
add('NeedleandThread', 'http://needleandthread.comicgenesis.com/')
add('NekkoandJoruba', 'http://nekkoandjoruba.comicgenesis.com/d/20050816.html')
add('Nekotime', 'http://nekotime.comicgenesis.com/')
add('Netjeru', 'http://netjeru.comicgenesis.com/')
add('NeverYouMind', 'http://neveryoumind.comicgenesis.com/')
add('NewProject', 'http://forumite.comicgenesis.com/')
add('NewTechLab', 'http://gaiata.comicgenesis.com/')
add('NewTraditionalists', 'http://newtraditionalists.comicgenesis.com/')
add('Newscast', 'http://newscast.comicgenesis.com/')
add('NiceGuysFinishLast', 'http://niceguys.comicgenesis.com/')
add('NightShiftWEBComix', 'http://webcomix.comicgenesis.com/')
add('NighthawkDayhawk', 'http://nighthawkdayhawk.comicgenesis.com/')
add('NightwolfCentral', 'http://nightwolfcentral.comicgenesis.com/')
add('No4thWalltoBreak', 'http://no4thwalltobreak.comicgenesis.com/d/20041025.html')
add('NoCrap', 'http://nocrap.comicgenesis.com/')
add('NoTimeForLife', 'http://randyraven.comicgenesis.com/')
add('NobtheBlob', 'http://nobtheblob.comicgenesis.com/')
add('Noidea', 'http://noidea.comicgenesis.com/')
add('NoneMoreComic', 'http://nonemore.comicgenesis.com/')
add('NosesOptional', 'http://nosesoptional.comicgenesis.com/')
add('NothingLikeSanity', 'http://nothinglikesanity.comicgenesis.com/')
add('NothingSpecial', 'http://nothingspecial.comicgenesis.com/')
add('NowhereUniversity', 'http://nowhereu.comicgenesis.com/')
add('NthDimension', 'http://nthdimension.comicgenesis.com/')
add('ODARKCITY', 'http://odark.comicgenesis.com/')
add('ODCKS', 'http://odcks.comicgenesis.com/')
add('ORBVS', 'http://orbvs.comicgenesis.com/')
add('OfDoom', 'http://ofdoom.comicgenesis.com/')
add('OfSomethingandNothinginParticular', 'http://osanip.comicgenesis.com/')
add('Olliverandthatotherguy', 'http://olliverotherguy.comicgenesis.com/')
add('OmakeOmatsuri', 'http://omakeomatsuri.comicgenesis.com/')
add('Omoshiroku', 'http://omoshiroku.comicgenesis.com/')
add('OnThePlayground', 'http://otp.comicgenesis.com/')
add('OnandAcross', 'http://theopell.comicgenesis.com/')
add('OnceUponASTAR', 'http://lonestar.comicgenesis.com/')
add('OpportunityofaLifetime', 'http://carpathia.comicgenesis.com/')
add('OralSex', 'http://birdland.comicgenesis.com/')
add('OrangePenguins', 'http://orangepenguins.comicgenesis.com/')
add('Orbz', 'http://orbz.comicgenesis.com/')
add('OrdinaryPeople', 'http://ordinarypeople.comicgenesis.com/')
add('OtakuKyokai', 'http://otakukyokai.comicgenesis.com/d/20060818.html')
add('OtenbaFiles', 'http://neohazard.comicgenesis.com/')
add('OurTripThruHell', 'http://phritzi.comicgenesis.com/')
add('OutOfCharacterComics', 'http://ooccomic.comicgenesis.com/')
add('OwMySanity', 'http://owmysanity.comicgenesis.com/')
add('PET', 'http://petcomic.comicgenesis.com/d/20070413.html')
add('PPMBnGRF', 'http://ppmbngrf.comicgenesis.com/')
add('PSIAPessimisticSenseofInadequacy', 'http://fesworks.comicgenesis.com/')
add('PaladinsAndaposHaven', 'http://paladin.comicgenesis.com/')
add('PandP', 'http://pandpcomic.comicgenesis.com/d/20021002.html')
add('Pandala', 'http://pandala.comicgenesis.com/')
add('Pandimaniacs', 'http://pandimaniacs.comicgenesis.com/')
add('PanelsTheExperimentation', 'http://panels.comicgenesis.com/')
add('Panic7', 'http://panic7.comicgenesis.com/')
add('PanicHighSchool', 'http://panichighschool.comicgenesis.com/')
add('PantsofDeath', 'http://pantsofdeath.comicgenesis.com/')
add('Paradigm', 'http://paradigm.comicgenesis.com/d/20020716.html')
add('ParallelDementia', 'http://paralleldementia.comicgenesis.com/d/20071221.html')
add('PartyGoers', 'http://partygoers.comicgenesis.com/')
add('PatchworkChampions', 'http://yeti.comicgenesis.com/')
add('Patheticity', 'http://patheticity.comicgenesis.com/')
add('PeopleIHateacollectabletradingcardgame', 'http://peopleihate.comicgenesis.com/')
add('PhantomThesis', 'http://phantomthesis.comicgenesis.com/')
add('PhatypusProductions', 'http://random.comicgenesis.com/')
add('PhilAndBob', 'http://drjon.comicgenesis.com/')
add('PhillerSpace', 'http://phillerspace.comicgenesis.com/')
add('PhillikesTacos', 'http://philtaco.comicgenesis.com/')
add('Phoenix', 'http://phoenix1.comicgenesis.com/')
add('PinkyTA', 'http://ozoneocean.comicgenesis.com/')
add('PiresAway', 'http://piresaway.comicgenesis.com/')
add('PixieVale', 'http://pixievale.comicgenesis.com/')
add('PlanetsCollide', 'http://ruthcomix.comicgenesis.com/d/20010706.html')
add('PlayingwithKnives', 'http://pwk.comicgenesis.com/')
add('PockyofJustice', 'http://poj.comicgenesis.com/')
add('Poesy', 'http://poesy.comicgenesis.com/')
add('Point', 'http://pointcomics.comicgenesis.com/')
add('PointGuardian', 'http://www.pointguardian.com/')
add('Pointless', 'http://pointless.comicgenesis.com/')
add('PokChow', 'http://blueguy.comicgenesis.com/')
add('PonderandEnlightening', 'http://pande.comicgenesis.com/')
add('Pr0nCrest', 'http://pr0ncrest.comicgenesis.com/')
add('PrismaticVodka', 'http://drunkenscribblings.comicgenesis.com/')
add('ProfessionalThieveryCircleofCzernobog', 'http://pthievery.comicgenesis.com/')
add('ProfessorSaltinesAstrodynamicDirigible', 'http://drsaltine.comicgenesis.com/')
add('ProjectADAM', 'http://themortician.comicgenesis.com/')
add('ProjectSERAPH', 'http://projectseraph.comicgenesis.com/')
add('PropertyofGwen', 'http://propertyofgwen.comicgenesis.com/')
add('ProtectMyBalls', 'http://protectmyballs.comicgenesis.com/')
add('Psiotechniqa', 'http://psitech.comicgenesis.com/')
add('PsychicDyslexiaInstitute', 'http://pdi.comicgenesis.com/')
add('PublicidadeEnganosa', 'http://publicidadeenganosa.comicgenesis.com/')
add('PurpleDuckMambo', 'http://purpleduckmambo.comicgenesis.com/')
add('QuestionableQuestersandShadowsofFate', 'http://qqandsof.comicgenesis.com/')
add('Quickbiteme', 'http://quickbiteme.comicgenesis.com/')
add('Quuren', 'http://quuren.comicgenesis.com/')
add('RMsothercomics', 'http://tom.comicgenesis.com/')
add('RadsFilesRanosSeries', 'http://radsfilesranos.comicgenesis.com/')
add('RandomAxeOfKindness', 'http://randomaxe.comicgenesis.com/')
add('RandytheCat', 'http://randythecat.comicgenesis.com/')
add('Rangers', 'http://rangers.comicgenesis.com/')
add('Rationale', 'http://rationale.comicgenesis.com/')
add('RealityCheque', 'http://realitycheque.comicgenesis.com/')
add('Reclamation', 'http://reclamation.comicgenesis.com/')
add('RedLexi', 'http://redlexi.comicgenesis.com/')
add('ReploidFriends', 'http://reploidfriends.comicgenesis.com/')
add('Requiem', 'http://erech.comicgenesis.com/')
add('Restaurant', 'http://restaurant.comicgenesis.com/')
add('RetailWeekly', 'http://retail.comicgenesis.com/')
add('ReturntoEden', 'http://returntoeden.comicgenesis.com/')
add('ReverendRanda', 'http://reverendranda.comicgenesis.com/')
add('RidingtheMediumBus', 'http://pencilears.comicgenesis.com/')
add('RitasComic', 'http://ritascomic.comicgenesis.com/')
add('RoadfromNowhere', 'http://nowhere.comicgenesis.com/')
add('RoboFlan', 'http://lewiscode.comicgenesis.com/')
add('RobotandBoy', 'http://faeta.comicgenesis.com/')
add('RoguesofClwydRhan', 'http://rocr.comicgenesis.com/')
add('Roughies', 'http://www.roughies.com/')
add('RoxxorUniversity', 'http://roxxoru.comicgenesis.com/')
add('Rugg', 'http://rugg.comicgenesis.com/')
add('RuneMaster', 'http://runemaster.comicgenesis.com/d/20050607.html')
add('SLAYERSREWIND', 'http://wyldcherry.comicgenesis.com/')
add('SMACK', 'http://smack.comicgenesis.com/')
add('SSComix', 'http://sscomix.comicgenesis.com/')
add('STFU', 'http://stfu.comicgenesis.com/')
add('SaintPetersCross', 'http://saintpeterscross.comicgenesis.com/')
add('SalemUncommons', 'http://salemuncommons.comicgenesis.com/')
add('SamandElisAdventures', 'http://sameliadv.comicgenesis.com/')
add('SamuraiMushroom', 'http://samuraimushroom.comicgenesis.com/')
add('SandwichWorld', 'http://sandwichworld.comicgenesis.com/')
add('SarahZero', 'http://plughead.comicgenesis.com/')
add('SaturdayMorningBreakfastCereal', 'http://smbc.comicgenesis.com/')
add('ScandalSheet', 'http://scandalsheet.comicgenesis.com/')
add('Scatterplot', 'http://scatterplot.comicgenesis.com/')
add('SceneMan', 'http://sceneman.comicgenesis.com/')
add('SchoolDaze', 'http://schooldaze.comicgenesis.com/')
add('ScrewJeffOwens', 'http://screwjeffowens.comicgenesis.com/')
add('ScrollDynasty', 'http://scrolldynasty.comicgenesis.com/')
add('SeabrooksWebComicSerials', 'http://lauraseabrook.comicgenesis.com/')
add('Seagate', 'http://seatgate.comicgenesis.com/')
add('SeaofInsanity', 'http://fractuslux.comicgenesis.com/')
add('SearchfortheSevenCrystals', 'http://sevencrystals.comicgenesis.com/')
add('SecondStage', 'http://secondstage.comicgenesis.com/')
add('Section12', 'http://section12.comicgenesis.com/')
add('Section972', 'http://section972.comicgenesis.com/')
add('SecurityBlanket', 'http://insecurities.comicgenesis.com/')
add('ShadowPlanet', 'http://shadowplanet.comicgenesis.com/')
add('ShadowedLight', 'http://shadowedlight.comicgenesis.com/')
add('Shapes', 'http://shapes.comicgenesis.com/')
add('Shifters', 'http://shifters.comicgenesis.com/')
add('ShineGetDumplingsGoGoTower', 'http://shinegotower.comicgenesis.com/')
add('Shinkutokimekisempukaku', 'http://yamcha.comicgenesis.com/')
add('ShinobiHigh', 'http://shinobihigh.comicgenesis.com/d/20020118.html')
add('ShonenChikara', 'http://shonenchikara.comicgenesis.com/')
add('SideEffects', 'http://sideeffects.comicgenesis.com/')
add('SidekickGirl', 'http://sidekickgirl.comicgenesis.com/')
add('Silvette', 'http://silvette.comicgenesis.com/')
add('SimonsWorld', 'http://simonsworld.comicgenesis.com/')
add('SinPerspectiva', 'http://mysp.comicgenesis.com/')
add('SinisterBedfellows', 'http://mckenzee.comicgenesis.com/')
add('SinkorDrown', 'http://sinkordrown.comicgenesis.com/')
add('SinsAgainstNature', 'http://sane.comicgenesis.com/')
add('SippansSerie', 'http://sippan.comicgenesis.com/')
add('SitandSpin', 'http://sitandspin.comicgenesis.com/')
add('SixByNineCollege', 'http://sixbyninecollege.comicgenesis.com/')
add('SixSeconds', 'http://sixseconds.comicgenesis.com/')
add('Sketchbook', 'http://sss.comicgenesis.com/')
add('SkimlinescomAcollectionofthings', 'http://www.skimlines.com/')
add('SlackersandLosers', 'http://slackersandlosers.comicgenesis.com/')
add('Sluggy', 'http://sluggy.comicgenesis.com/')
add('Smapdi', 'http://smapdi.comicgenesis.com/')
add('Smitty', 'http://smitty.comicgenesis.com/')
add('Smut', 'http://smut.comicgenesis.com/')
add('SoWhat', 'http://sowhat.comicgenesis.com/')
add('Socializedmedicine', 'http://socializedmedicine.comicgenesis.com/')
add('Sockd', 'http://www.sockd.com/')
add('Something', 'http://something.comicgenesis.com/')
add('SomewhereCalledHemel', 'http://hemel.comicgenesis.com/')
add('SomewhereIBelong', 'http://zhongda.comicgenesis.com/')
add('Sorryfortheinconvenience', 'http://ranreppowned.comicgenesis.com/')
add('SpaceLosers', 'http://spacelosers.comicgenesis.com/')
add('SpareChange', 'http://sparechange.comicgenesis.com/')
add('Special', 'http://special.comicgenesis.com/')
add('Spiderfrogballoon', 'http://spiderfrogballoon.comicgenesis.com/')
add('SplendiforousEscapades', 'http://splendiforous.comicgenesis.com/')
add('SpoononHighandFireontheMountian', 'http://spoon.comicgenesis.com/')
add('SpoutingNonsense', 'http://spoutingnonsense.comicgenesis.com/')
add('SpringerandKonijn', 'http://springerandkonijn.comicgenesis.com/')
add('SpriteShow', 'http://spriteshow.comicgenesis.com/')
add('SpriteU', 'http://spriteu.comicgenesis.com/')
add('SpritesofDOOM', 'http://sodoom.comicgenesis.com/')
add('SquareAndRhomboid', 'http://sar.comicgenesis.com/')
add('Squaresville', 'http://squaresville.comicgenesis.com/')
add('SquidNinja', 'http://www.squidninja.com/')
add('SquishyTales', 'http://dmg.comicgenesis.com/')
add('StagnantWaters', 'http://stagnantwaters.comicgenesis.com/')
add('StalagAndapos99', 'http://www.stalag99.net/')
add('StalkingMillionaires', 'http://packrat.comicgenesis.com/')
add('StarBored', 'http://oosterwijk.comicgenesis.com/')
add('StarShip', 'http://starship.comicgenesis.com/')
add('StartWreck', 'http://startwreck.comicgenesis.com/')
add('SteveandMac', 'http://steveandmac.comicgenesis.com/')
add('StickmanLimited', 'http://stickmanltd.comicgenesis.com/')
add('StickyEvil', 'http://stickyevil.comicgenesis.com/')
add('StraightAhead', 'http://straightahead.comicgenesis.com/')
add('StrangeDaze', 'http://strangedaze.comicgenesis.com/')
add('StrangeFruit', 'http://strangefruit.comicgenesis.com/')
add('StrippedAgain', 'http://strippedagain.comicgenesis.com/')
add('StuffofLegends', 'http://stuffoflegends.comicgenesis.com/')
add('StupidComics', 'http://stupidcomics.comicgenesis.com/')
add('SubjectToChange', 'http://subjecttochange.comicgenesis.com/')
add('Sublunary', 'http://sublunary.comicgenesis.com/')
add('SueosdelSur', 'http://sds.comicgenesis.com/')
add('SuicideForHire', 'http://suicideforhire.comicgenesis.com/')
add('Summoners', 'http://summoners.comicgenesis.com/')
add('SuperChibiDeathBots', 'http://scdb.comicgenesis.com/')
add('SuperFightFight', 'http://sff.comicgenesis.com/')
add('SuperTemps', 'http://megaskunjii.comicgenesis.com/')
add('SupersonicSoniica', 'http://triples.comicgenesis.com/')
add('SurrealU', 'http://surrealu.comicgenesis.com/')
add('SushiComics', 'http://sushi.comicgenesis.com/')
add('SynapticMisfires', 'http://synapticmisfires.comicgenesis.com/')
add('Synapticisms', 'http://synapticisms.comicgenesis.com/')
add('TChanCardMasterJunichiAsktheProfessorandMore', 'http://tsunamichan.comicgenesis.com/')
add('THELEGENDofCHUCKOLIANG', 'http://chuckoliang.comicgenesis.com/')
add('TORMENT', 'http://torment.comicgenesis.com/')
add('Tabletron', 'http://tabletron.comicgenesis.com/')
add('TailsofIxinia', 'http://nalkari.comicgenesis.com/')
add('Tainted', 'http://tainted.comicgenesis.com/')
add('TakingStock', 'http://mapaghimagsik.comicgenesis.com/')
add('TalesOfPylea', 'http://talesofpylea.comicgenesis.com/')
add('Talkin', 'http://talkin.comicgenesis.com/')
add('TalkingHead', 'http://talkinghead.comicgenesis.com/')
add('Tandava', 'http://tandava.comicgenesis.com/')
add('TangsComics', 'http://tang.comicgenesis.com/')
add('TapeLoop', 'http://jisk.comicgenesis.com/')
add('TeacosiesWithIronyLargePrint', 'http://teacosieswithironylargeprint.comicgenesis.com/')
add('TeddyBearAntiChrist', 'http://tbac.comicgenesis.com/')
add('TemplarArizona', 'http://templaraz.comicgenesis.com/')
add('TheAcademy', 'http://theacademy.comicgenesis.com/')
add('TheAdventuresofGralax', 'http://gralax.comicgenesis.com/')
add('TheAdventuresofKaniraBaxter', 'http://kanirabaxter.comicgenesis.com/')
add('TheAdventuresofLilDenverPastrami', 'http://lildenverpastrami.comicgenesis.com/')
add('TheAdventuresofPopsicleman', 'http://popsicleman.comicgenesis.com/')
add('TheAdventuresofSpaceDevil', 'http://spacedevil.comicgenesis.com/')
add('TheAdventuresofSuperGeometryDude', 'http://supergeometrydude.comicgenesis.com/')
add('TheAdventuresofUs', 'http://adventuresofus.comicgenesis.com/')
add('TheAdventuresofVindibuddSuperheroInTraining', 'http://vindibudd.comicgenesis.com/d/20070720.html')
add('TheAdventuresofWharsMeBrainDude', 'http://jamellan.comicgenesis.com/')
add('TheAnarchist', 'http://theanarchist.comicgenesis.com/')
add('TheBigheads', 'http://thebigheads.comicgenesis.com/')
add('TheBlazeArmada', 'http://blazearmada.comicgenesis.com/')
add('TheBookOfHuzzah', 'http://theboh.comicgenesis.com/')
add('TheBrainAnOwnersManual', 'http://thebrain.comicgenesis.com/')
add('TheCallofWhatever', 'http://tcow.comicgenesis.com/')
add('TheCandidate', 'http://kennystrife.comicgenesis.com/')
add('TheChiWanChikiDojo', 'http://chiwanchiki.comicgenesis.com/')
add('TheChildrenofMoloch', 'http://moloch.comicgenesis.com/')
add('TheCorruptionofTed', 'http://corruption.comicgenesis.com/')
add('TheCovetedPorch', 'http://covetedporch.comicgenesis.com/')
add('TheCrossoverlord', 'http://crossoverlord.comicgenesis.com/')
add('TheDOOMArmy', 'http://experimental.comicgenesis.com/')
add('TheDayitSnowed', 'http://tdis.comicgenesis.com/')
add('TheDementiaofMagic', 'http://dementia.comicgenesis.com/')
add('TheEarwigChronicles', 'http://rnes.comicgenesis.com/')
add('TheEasyBreather', 'http://easybreather.comicgenesis.com/')
add('TheEvilThatMenDo', 'http://theevilthatmendo.comicgenesis.com/')
add('TheFantasticalBestiary', 'http://fantasticalbestiary.comicgenesis.com/')
add('TheFinalFantasy6Comic', 'http://ff6comic.comicgenesis.com/')
add('TheFoolishAdventuresofKirbyandSambo', 'http://kirbyandsambo.comicgenesis.com/')
add('TheFoxfireChronicles', 'http://foxfire.comicgenesis.com/')
add('TheFreneticAdventuresofFredBarlowe', 'http://fredbarlowe.comicgenesis.com/')
add('TheGeekWay', 'http://geekway.comicgenesis.com/')
add('TheGodlyandtheDamned', 'http://gandd.comicgenesis.com/')
add('TheGodsPack', 'http://godspack.comicgenesis.com/')
add('TheGreatTree', 'http://tgt.comicgenesis.com/')
add('TheGreenAvenger', 'http://www.green-avenger.com/')
add('TheGrimbles', 'http://grimbles.comicgenesis.com/')
add('TheHappyPenis', 'http://happypenis.comicgenesis.com/')
add('TheHoojieCrew', 'http://hoojiecrew.comicgenesis.com/')
add('TheInexplicableAdventuresofBob', 'http://bobadventures.comicgenesis.com/')
add('TheInfamous', 'http://theinfamous.comicgenesis.com/')
add('TheInstituteofMetaphysics', 'http://iofm.comicgenesis.com/')
add('TheInterns', 'http://theinterns.comicgenesis.com/')
add('TheJaded', 'http://www.thejaded.co.uk/')
add('TheKillingMoon', 'http://thekillingmoon.comicgenesis.com/')
add('TheLawofPurple', 'http://dragongirl.comicgenesis.com/')
add('TheLilWorldofMeekerz', 'http://meekerz.comicgenesis.com/')
add('TheLindleyHallProjectMk2', 'http://tlhp.comicgenesis.com/')
add('TheLoneSwordsman', 'http://theloneswordsman.comicgenesis.com/')
add('TheLounge', 'http://thelounge.comicgenesis.com/')
add('TheManWhoHatesFun', 'http://mwhf.comicgenesis.com/')
add('TheMariposaRevelation', 'http://mariposa.comicgenesis.com/')
add('TheMaryComic', 'http://themarycomic.comicgenesis.com/')
add('TheMcRemnantReport', 'http://mcrreport.comicgenesis.com/')
add('TheMidlands', 'http://midlands.comicgenesis.com/')
add('TheMintWhelpSaga', 'http://mintwhelp.comicgenesis.com/')
add('TheMisadventuresofOkk', 'http://okk.comicgenesis.com/')
add('TheNEWTalesfromWollemiHeights', 'http://wollemi.comicgenesis.com/')
add('TheNakedElf', 'http://nakedelf.comicgenesis.com/')
add('TheNextLevel', 'http://chrisandcrew.comicgenesis.com/')
add('TheNineteenthCenturyIndustrialist', 'http://thebaron.comicgenesis.com/')
add('TheNutcracker', 'http://nutcracker.comicgenesis.com/')
add('TheOfficeBitch', 'http://picklejuice.comicgenesis.com/')
add('ThePantheon', 'http://pantheon.comicgenesis.com/')
add('ThePath', 'http://thepath.comicgenesis.com/')
add('ThePictureDiary', 'http://thepicturediary.comicgenesis.com/')
add('ThePolygonReports', 'http://polygonreports.comicgenesis.com/')
add('ThePoptasticLeague', 'http://poptasticleague.comicgenesis.com/')
add('ThePrimeofAmbition', 'http://jaadrih.comicgenesis.com/')
add('TheProfessor', 'http://xuanwu.comicgenesis.com/')
add('TheRobmanShow', 'http://therobmanshow.comicgenesis.com/')
add('TheSagaofGagerff2', 'http://gager.comicgenesis.com/')
add('TheShortEnd', 'http://theshortend.comicgenesis.com/')
add('TheSiteMap', 'http://sitemap.comicgenesis.com/')
add('TheSomethingSomethingofSomethingSomethingness', 'http://somethingstrange.comicgenesis.com/')
add('TheStickFigureDragons', 'http://feychild.comicgenesis.com/')
add('TheStraightJacketFreedomForce', 'http://tsjff.comicgenesis.com/')
add('TheSuperPeoples', 'http://superpeoples.comicgenesis.com/')
add('TheSuperSmashInn', 'http://supersmashinn.comicgenesis.com/')
add('TheTalesofKalduras', 'http://kalduras.comicgenesis.com/')
add('TheVolet', 'http://volet.comicgenesis.com/')
add('TheWarofWinds', 'http://warofwinds.comicgenesis.com/')
add('TheWingsOfChange', 'http://wingsofchange.comicgenesis.com/')
add('TheWoodenLeg', 'http://thewoodenleg.comicgenesis.com/')
add('TheWrongBand', 'http://thewrongband.comicgenesis.com/')
add('Theadventuresofmegamanandlink', 'http://takeru.comicgenesis.com/')
add('Theendofthings', 'http://endofthings.comicgenesis.com/')
add('Thelifeofthekalahari', 'http://lifeofthekalahari.comicgenesis.com/')
add('Themisanthropes', 'http://misanthropes.comicgenesis.com/')
add('Themouseoftime', 'http://mouseoftime.comicgenesis.com/')
add('Thespiphobia', 'http://thespiphobia.comicgenesis.com/')
add('TheyCallMePhatDragon', 'http://callmephat.comicgenesis.com/')
add('ThinginessofChaos', 'http://thinginess.comicgenesis.com/')
add('ThirdDementia', 'http://thirddementia.comicgenesis.com/')
add('ThisDonAndapostMakeNoSense', 'http://makesnosense.comicgenesis.com/')
add('ThisISLife', 'http://thisislife.comicgenesis.com/')
add('ThreeCatsAndAMouse', 'http://team3c1m.comicgenesis.com/')
add('ThroughTheseEyes', 'http://hindsight2117.comicgenesis.com/')
add('Throwback', 'http://wintersolstice.comicgenesis.com/')
add('Thwack', 'http://thwack.comicgenesis.com/')
add('Tie_Guy', 'http://tieguy.comicgenesis.com/')
add('TimePig', 'http://timepig.comicgenesis.com/')
add('TipoftheSword', 'http://tipofthesword.comicgenesis.com/')
add('TitlePending', 'http://titlepend.comicgenesis.com/')
add('TonjaSteele', 'http://tonjasteele.comicgenesis.com/')
add('ToonPimpsPalace', 'http://mhitmand.comicgenesis.com/')
add('ToyDivision', 'http://toydivision.comicgenesis.com/')
add('TrappedInAComic', 'http://mrsynnerster75.comicgenesis.com/')
add('TreeSprocket', 'http://treesprocket.comicgenesis.com/')
add('TrenttheEmoGoth', 'http://lifeispain.comicgenesis.com/')
add('Trevino', 'http://noskillz.comicgenesis.com/')
add('TrialandError', 'http://trialanderror.comicgenesis.com/')
add('TripleTrouble', 'http://tripletrouble.comicgenesis.com/')
add('TriumphantLosers', 'http://triumphantlosers.comicgenesis.com/d/20081006.html')
add('TrueBums', 'http://truebums.comicgenesis.com/')
add('TurboNinjaBastard', 'http://tnb.comicgenesis.com/')
add('TurboTrak', 'http://turbotrak.comicgenesis.com/')
add('TuringsFollyIITheAdventuresOfPhil', 'http://proteancomics.comicgenesis.com/')
add('Tutelar', 'http://coffeystreet.comicgenesis.com/')
add('TwiceDestined', 'http://twicedestined.comicgenesis.com/')
add('TwistedTales', 'http://www.jastiv.com/')
add('UBERGEEKSpriteWorld', 'http://www.ubergeekthecomic.com/')
add('URCult', 'http://urcult.comicgenesis.com/')
add('UltrafreakcomicsSygnosis', 'http://ultrafreak.comicgenesis.com/')
add('Umlauthouse', 'http://umlauthouse.comicgenesis.com/')
add('UncertaintyPrinciple', 'http://uncertaintyprinciple.comicgenesis.com/')
add('Unconventional', 'http://unconventional.comicgenesis.com/')
add('UnfamiliarReflection', 'http://emri.comicgenesis.com/')
add('UnlifeOnline', 'http://unlifeonline.comicgenesis.com/')
add('UnseenFate', 'http://unseenfate.comicgenesis.com/')
add('UntitledAgain', 'http://untitledagain.comicgenesis.com/')
add('UrbanFable', 'http://urbanfable.comicgenesis.com/')
add('Usrbinw00t', 'http://usrbinw00t.comicgenesis.com/')
add('VRPG', 'http://vrpg.comicgenesis.com/')
add('ValkyrieSymphony', 'http://allegranova.comicgenesis.com/')
add('VampiresCurse', 'http://vampire.comicgenesis.com/')
add('VampiresandCannibals', 'http://vannibals.comicgenesis.com/')
add('VaporLock', 'http://vaporlock.comicgenesis.com/')
add('Veena', 'http://veena.comicgenesis.com/')
add('VenusAscending', 'http://catgirldo.comicgenesis.com/')
add('VeritysArk', 'http://veritycomic.comicgenesis.com/')
add('VicandEdwards', 'http://vicandedwards.comicgenesis.com/')
add('ViciousLies', 'http://viciouslies.comicgenesis.com/')
add('VictorianTimes', 'http://victorian.comicgenesis.com/')
add('VideoGameAddicts', 'http://vgaddicts.comicgenesis.com/')
add('WORLDDICTATORComicsPresentsWhenImWorldDictator', 'http://worlddictator.comicgenesis.com/')
add('WadeintheDeepEnd', 'http://wade.comicgenesis.com/')
add('WakeUpScreaming', 'http://wakeupscreaming.comicgenesis.com/')
add('WakingtheHouseofRaeux', 'http://viistar.comicgenesis.com/')
add('WarMageNC17', 'http://warmage.comicgenesis.com/')
add('WarningBucketsOfBlood', 'http://chaoticcomics.comicgenesis.com/')
add('WebcomicTheWebcomicWebcomicWebcomicWebcomic', 'http://dannormnsanidey.comicgenesis.com/')
add('WeekendWarriors', 'http://weekendwarriors.comicgenesis.com/')
add('WeirdnessRules', 'http://weirdness.comicgenesis.com/')
add('WeirdosUtopia', 'http://weirdosutopia.comicgenesis.com/')
add('WelcomeToRoxboro', 'http://roxborocomic.comicgenesis.com/')
add('WelcometoShior', 'http://shior.comicgenesis.com/')
add('WestofBathurst', 'http://westofbathurst.comicgenesis.com/')
add('Whale', 'http://whale.comicgenesis.com/')
add('WhatHappensNext', 'http://whn.comicgenesis.com/')
add('WhatYouDontSee', 'http://phantomlady4.comicgenesis.com/')
add('Whatever', 'http://www.whatevercomic.com/')
add('Whatthehell', 'http://whatthehell.comicgenesis.com/')
add('WhereGodsandMortalsDance', 'http://wgmd.comicgenesis.com/')
add('WhiteFeather', 'http://whitefeathermanga.comicgenesis.com/')
add('WhiteHouseinOrbit', 'http://whio.comicgenesis.com/')
add('WhyImNotAnArtist', 'http://whyimnotanartist.comicgenesis.com/')
add('WhyMeComics', 'http://whymecomics.comicgenesis.com/')
add('WiCCAN', 'http://wiccan.comicgenesis.com/')
add('Wierdman', 'http://asa.comicgenesis.com/')
add('WillyMorgan', 'http://willymorgan.comicgenesis.com/')
add('Wingmen', 'http://wingmen.comicgenesis.com/')
add('WishInOneHand', 'http://wishin1hand.comicgenesis.com/')
add('Witchprickers', 'http://buxompiratewench.comicgenesis.com/')
add('Witticisma', 'http://witticisma.comicgenesis.com/')
add('WizardAndWarrior', 'http://wizardandwarrior.comicgenesis.com/')
add('Wizztards', 'http://wizztards.comicgenesis.com/')
add('WonTonHammer', 'http://wonton.comicgenesis.com/')
add('WonderWig', 'http://wonderwig.comicgenesis.com/')
add('WoodsForTheTrees', 'http://woodsforthetrees.comicgenesis.com/')
add('WorldofFizz', 'http://fergoandenrique.comicgenesis.com/')
add('WrathofHeaven', 'http://wrath.comicgenesis.com/')
add('XCHOPSTICKSxNeo', 'http://chopsticksneo.comicgenesis.com/')
add('XartinDelic', 'http://xartindelic.comicgenesis.com/')
add('YARKRAMERSFIRSTREALITY', 'http://firstreality.comicgenesis.com/')
add('YKAnime', 'http://ykanime.comicgenesis.com/')
add('YOSH', 'http://yosh.comicgenesis.com/')
add('YahtzeeTakesOnTheWorld', 'http://yahtzee.comicgenesis.com/')
add('YangChild', 'http://yangchild.comicgenesis.com/')
add('YellowSticky', 'http://yellowsticky.comicgenesis.com/')
add('YinandYang', 'http://www.yin-and-yang.com/')
add('YourGuideToMakeupAnarchyandAnthros', 'http://creepylilgothkids.comicgenesis.com/')
add('YourInAiryTract', 'http://yourinairytract.comicgenesis.com/')
add('Youtoo', 'http://youtoo.comicgenesis.com/')
add('Yvette', 'http://yvette.comicgenesis.com/')
add('Zarla', 'http://zarla.comicgenesis.com/')
add('ZeeratheSpacePirate', 'http://zeera.comicgenesis.com/')
add('Zelon', 'http://zelon.comicgenesis.com/')
add('ZeuU', 'http://zeurinu.comicgenesis.com/')
add('Zoology', 'http://thezoo.comicgenesis.com/')
add('ZorroAndEster', 'http://zorroandester.comicgenesis.com/')
add('Zortic', 'http://zortic.comicgenesis.com/d/20030922.html')
add('ZosKias', 'http://kojika.comicgenesis.com/')
add('ZowieMyerson', 'http://camcorder.comicgenesis.com/')
