import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule

class EarthsongSaga(BasicComicModule):
    latestUrl = 'http://www.earthsongsaga.com/'
    imageSearch = re.compile(r'<img src="((?:\.\./)?images/Episode%?\d+/\w+\.jpg)"')
    prevSearch = re.compile(r'<a href="([^"]+\.html)"[^>]*><img src="(?:\.\./)?images/(template/buttons/leaf2-fade|testing/prev)\.jpg"')

    def getFilename(self, imageUrl, pageUrl):
        imgmatch = re.compile(r'(?:%20)?(\d+)/(\w+)\.[a-z]*$', re.IGNORECASE).search(imageUrl)
        return imgmatch.group(1) + '_' + imgmatch.group(2)

