import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule

class KevinAndKell(BasicComicModule):
    latestUrl = 'http://www.kevinandkell.com/'
    imageUrl = 'http://www.kevinandkell.com/%s/kk%s%s.html'
    imageSearch = re.compile(r'<img.+?src="((\d+/)?strips/kk\d+.gif)"', re.IGNORECASE)
    prevSearch = re.compile(r'<a.+?href="((\.\./)?\d+/kk\d+\.html)"[^>]*><span>Previous Strip', re.IGNORECASE)
    help = 'Index format: yyyy-mm-dd'

    def setStrip(self, index):
        self.currentUrl = self.imageUrl % tuple(map(int, index.split('-')))
