import re
from dosage import util
from dosage.modules.helpers.BasicComicModule import BasicComicModule

class UClick(BasicComicModule):
    homepage = 'http://content.uclick.com/a2z.html'
    baseUrl = 'http://www.uclick.com/client/zzz/%s'
    latestUrl = '/'
    imageUrl = '/%s/'
    imageSearch = re.compile(r'<img.+?src="(/feature/\d{2}/\d{2}/\d{2}/.+?.gif)">', re.IGNORECASE)
    prevSearch = re.compile(r'<a href="(/client/zzz/\w+/\d{4}/\d{2}/\d{2}/)">Previous date', re.IGNORECASE)
    help = 'Index format: yyyy/mm/dd'

    submodules = {
        '7DayMenuPlanner': 'mu',
        '9To5': 'tmntf',
        'AdamHome': 'ad',
        'Agnes': 'cragn',
        'AlcarazLalo': 'la',
        'AlcarazLaloSpanish': 'spla',
        'AndersonNick': 'wpnan',
        'AndyCapp': 'crcap',
        'AnimalCrackers': 'tmani',
        'Annie': 'tmann',
        'AsayChuck': 'crcas',
        'AsISeeIt': 'as',
        'AskShagg': 'crask',
        'AuthTony': 'ta',
        'BadReporter': 'bad',
        'Baldo': 'ba',
        'BaldoSpanish': 'be',
        'BallardStreet': 'crbal',
        'BC': 'crbc',
        'BCSpanish': 'crbcs',
        'BensonSteve': 'crsbe',
        'BigTop': 'bt',
        'Biographic': 'biov',
        'BobTheSquirrel': 'bob',
        'BokChip': 'crcbo',
        'BoNanas': 'bon',
        'BoondocksThe': 'bo',
        'BottomLiners': 'tmbot',
        'BoundAndGagged': 'tmbou',
        'Brainwaves': 'bwv',
        'BrendaStarr': 'tmbre',
        'BrewsterRockit': 'tmrkt',
        'BroomHilda': 'tmbro',
        'BuckleyWilliamF': 'wb',
        'BurnsScott': 'sb',
        'CanadianaCrossword': 'can',
        'Candorville': 'cand',
        'CarlsonStuart': 'sc',
        'CatalinoKen': 'crkca',
        'Cathy': 'ca',
        'CathySpanish': 'spca',
        'CEstLaVie': 'clv',
        'CityThe': 'derf',
        'ClearBlueWater': 'cbw',
        'Cleats': 'cle',
        'CloseToHome': 'cl',
        'CompuToon': 'tmcom',
        'Condorito': 'cond',
        'ConradPaul': 'tmpco',
        'Consejos': 'cons',
        'ConsejosSpanish': 'conse',
        'CookbookNook': 'cn',
        'Cornered': 'co',
        'CoulterAnn': 'ac',
        'CoveringTheCourtsTheWriterSArt': 'jk',
        'CreatingSpaces': 'csp',
        'Crucigramas': 'xp',
        'DanzigerJeff': 'jd',
        'DaviesMatt': 'tmmda',
        'DearAbby': 'da',
        'DeepCover': 'deep',
        'DeeringJohn': 'crjde',
        'DickTracy': 'tmdic',
        'DinetteSetThe': 'crdin',
        'DogEatDoug': 'crdog',
        'DonWright': 'tmdow',
        'Doodles': 'tmdoo',
        'Doonesbury': 'db',
        'DoubleDutyDinners': 'ddd',
        'DuplexThe': 'dp',
        'Earthweek': 'ew',
        'ElderberriesThe': 'eld',
        'FacesInTheNews': 'kw',
        'FamilyTimeCrossword': 'fti',
        'FigurativelySpeaking': 'fig',
        'FlightDeck': 'crfd',
        'FloAndFriends': 'crflo',
        'FlyingMccoysThe': 'fmc',
        'FocusOnTheFamily': 'do',
        'FocusOnTheFamilySpanish': 'spdo',
        'ForBetterOrForWorse': 'fb',
        'ForHeavenSSake': 'crfhs',
        'Foxtrot': 'ft',
        'FoxtrotSpanish': 'spft',
        'FrankAndErnest': 'fa',
        'FredBassetSpanish': 'spfba',
        'FredBasset': 'tmfba',
        'FuscoBrothersThe': 'fu',
        'GallagherMaggie': 'mg',
        'Garfield': 'ga',
        'GarfieldSpanish': 'gh',
        'GasolineAlley': 'tmgas',
        'GaturroSpanish': 'spgat',
        'GeyerGeorgieAnne': 'gg',
        'GilThorp': 'tmgil',
        'GingerMeggs': 'gin',
        'GingerMeggsSpanish': 'spgin',
        'GirlsAndSports': 'crgis',
        'GorrellBob': 'crbgo',
        'HammondBruce': 'hb',
        'HandelsmanWalt': 'tmwha',
        'HeartOfTheCity': 'hc',
        'Heathcliff': 'crhea',
        'HeathcliffSpanish': 'crhes',
        'HerbAndJamaal': 'crher',
        'HigginsJack': 'jh',
        'HollywoodLine': 'hal',
        'HorseyDavid': 'tmdho',
        'Housebroken': 'tmhou',
        'HubertAndAbby': 'haa',
        'IdiotBox': 'ibox',
        'InkPen': 'ink',
        'InTheBleachers': 'bl',
        'JamesBondSpanish': 'spjb',
        'JonesClay': 'crcjo',
        'JonesinCrossword': 'jnz',
        'JumbleClassic': 'tmjum',
        'JumbleForKids': 'tmjuk',
        'KakuroDiario': 'spkak',
        'Kakuro': 'kaku',
        'KallaugherKevin': 'cwkal',
        'KChroniclesThe': 'kk',
        'KelleySteve': 'crske',
        'KidsTalkAboutGod': 'kt',
        'Kudzu': 'tmkud',
        'LaCucaracha': 'lc',
        'LastWordInAstrology': 'el',
        'LastWordInAstrologySpanish': 'es',
        'LeoJohn': 'jl',
        'LibertyMeadows': 'crlib',
        'Lio': 'lio',
        'LocherDick': 'tmdlo',
        'LooseParts': 'tmloo',
        'LosAngelesTimesDailyCrossword': 'tmlap',
        'LostSheep': 'lost',
        'LoweChan': 'tmclo',
        'LuckovichMike': 'crmlu',
        'LuckyCow': 'luc',
        'MarletteDoug': 'tmdma',
        'MccoyGlenn': 'gm',
        'MeaningOfLilaThe': 'crlil',
        'MeehanStreak': 'tmmee',
        'MiddletonsThe': 'tmmee',
        'MinimumSecurity': 'ms',
        'ModestyBlaiseSpanish': 'spmb',
        'Momma': 'crmom',
        'MorinJim': 'cwjmo',
        'MotleyFoolThe': 'fm',
        'MrHandyperson': 'mh',
        'MuttJeffSpanish': 'spmut',
        'NascarInsider': 'na',
        'NationalPerspective': 'ds',
        'NaturalSelection': 'crns',
        'NestHeads': 'cpnst',
        'Netword': 'crnet',
        'Neurotica': 'neu',
        'NewsOfTheWeird': 'nw',
        'NewsOfTheWeirdSpanish': 'ns',
        'NonSequitur': 'nq',
        'OhmanJack': 'tmjoh',
        'OliphantPat': 'po',
        'OnAClaireDay': 'crocd',
        'OnComputers': 'oc',
        'OnComputersSpanish': 'spoc',
        'OneBigHappy': 'crobh',
        'OnEthics': 'ethic',
        'OtherCoastThe': 'crtoc',
        'OutOfTheGenePool': 'wpgen',
        'Overboard': 'ob',
        'OverboardSpanish': 'spob',
        'PardonMyWords': 'ha',
        'PepeSpanish': 'sppep',
        'PetConnection': 'pc',
        'PettJoel': 'jp',
        'Pickles': 'wppic',
        'Playfour': 'pff',
        'PlaytoniumCustomDailyJigsaw': 'pucdj',
        'Pluggers': 'tmplu',
        'PoochCafEacute': 'poc',
        'PoochCafEacuteSpanish': 'sppoc',
        'PopCulture': 'pop',
        'PowellDwane': 'crdpo',
        'Preteena': 'pr',
        'PricklyCity': 'prc',
        'QuigmansThe': 'tmqui',
        'RallComic': 'tr',
        'RallTedTextFeature': 'ru',
        'RealLifeAdventures': 'rl',
        'RedAndRover': 'wpred',
        'RedMeat': 'red',
        'ReynoldSUnwrapped': 'rw',
        'RichardReeves': 'rr',
        'RonaldinhoGaucho': 'ron',
        'RonaldinhoGauchoSpanish': 'spron',
        'Rootonym': 'tmroo',
        'Rubes': 'crrub',
        'SackSteve': 'tmssa',
        'SargentBen': 'bs',
        'SargentBenSpanish': 'spbs',
        'SendHelp': 'send',
        'ShenemanDrew': 'tmdsh',
        'Shoecabbage': 'shcab',
        'Shoe': 'tmsho',
        'SigmundSpanish': 'spsig',
        'Slowpoke': 'slow',
        'SmallWorld': 'small',
        'SmartMoves': 'sm',
        'SpeedBump': 'crspe',
        'StateOfTheUnion': 'crsou',
        'StayskalWayne': 'tmwst',
        'StoneSoup': 'ss',
        'StrangeBrew': 'crstr',
        'SudokuClassic': 'sudoc',
        'SudokuDiario': 'spsud',
        'SudokuMega': 'spsum',
        'SudokuMega': 'sudom',
        'SudokuMini': 'spsuk',
        'SudokuMini': 'sudok',
        'SummersDana': 'tmdsu',
        'SupermarketSampler': 'su',
        'SuttonImpact': 'stn',
        'Sylvia': 'tmsyl',
        'SzepPaul': 'crpsz',
        'TankMcnamara': 'tm',
        'TellMeAStory': 'ts',
        'TelnaesAnn': 'tmate',
        'ThePinkPanther': 'tmpnk',
        'TheWizardOfId': 'crwiz',
        'TheWizardOfIdSpanish': 'crwis',
        'ThInk': 'think',
        'ThroughThickAndThin': 'cpthk',
        'TinySepuku': 'tiny',
        'TolesTom': 'tt',
        'TomTheDancingBug': 'td',
        'TooMuchCoffeeMan': 'tmcm',
        'Trevor': 'trev',
        'TutelandiaSpanish': 'sptut',
        'UniversalJigsawForKids': 'kj',
        'UniversalJigsawPuzzle': 'uj',
        'UniversalTriviaFlashEdition': 'ftr',
        'UniversalWordSearch': 'ws',
        'UpDownWords': 'ucudw',
        'VarvelGary': 'crgva',
        'WassermanDan': 'tmdwa',
        'WatchYourHead': 'wpwyh',
        'WeePals': 'crwee',
        'WomanToWoman': 'wtw',
        'WonderwordFlashEdition': 'wwf',
        'WordRoundup': 'ucwr',
        'WorkingItOut': 'crwio',
        'Www4KidsOrg': 'fk',
        'YennySpanish': 'spyen',
        'Yenny': 'yen',
        'ZackHill': 'crzhi',
        'ZiggySpanish': 'spzi',
        'Ziggy': 'zi',
    }

    def __init__(self, submodule):
        BasicComicModule.__init__(self)
        self.baseUrl = self.baseUrl % submodule
        self.latestUrl = self.baseUrl + self.latestUrl
        self.imageUrl = self.baseUrl + self.imageUrl
        self.name = 'UComics' + '/' + submodule

    def fetchSubmodules(cls):
        exclusions = (
            'index',
            )

        submoduleSearch = re.compile(r'(<A HREF="http://content.uclick.com/content/\w+.html">[^>]+?</a>)', re.IGNORECASE)
        partsMatch = re.compile(r'<A HREF="http://content.uclick.com/content/(\w+?).html">([^>]+?)</a>', re.IGNORECASE)
        matches = util.fetchManyMatches(cls.homepage, (submoduleSearch,))[0]
        possibles = [partsMatch.match(match).groups() for match in matches]

        def normalizeName(name):
            name = name.title()
            return ''.join([c for c in name if c.isalnum()])

        def fetchSubmodule(module):
            try:
                return util.fetchUrl(cls.baseUrl % module, cls.prevSearch)
            except:
                return False
        return [normalizeName(name) for part, name in possibles if part not in exclusions and fetchSubmodule(part)]
    fetchSubmodules = classmethod(fetchSubmodules)

