from re import compile, IGNORECASE

from dosage.helpers import BasicScraper, queryNamer


class LasLindas(BasicScraper):
    latestUrl = 'http://www.katbox.net/laslindas/'
    imageUrl = 'http://www.katbox.net/laslindas/index.php?strip_id=%s'
    imageSearch = compile(r'"(istrip_files/strips/.+?)"')
    prevSearch = compile(r'</a><a href="/laslindas/(.+?)".+?prev')
    help = 'Index format: nn'


class LastBlood(BasicScraper):
    latestUrl = 'http://www.lastblood.net/main/'
    imageUrl = 'http://www.lastblood.net/main/%s'
    imageSearch = compile(r'(/comicfolder/.+?)" alt')
    prevSearch = compile(r'Previous C.+?"(http://www.lastblood.net/main/.+?)".+?</a>')
    help = 'Index format: yyyy/mm/dd/(page number and name)'


class LethalDosesClassic(BasicScraper):
    latestUrl = 'http://www.lethaldoses.com/archives.php?stripnum=99'
    imageUrl = 'http://www.lethaldoses.com/archives.php?stripnum=%s'
    imageSearch = compile(r'<img.+?src="(./archive/strip\d+\..+?)"')
    prevSearch = compile(r'<a href="(/?archives\.php\?stripnum=\d+)"><img.+?src="\./images/nav_prev.gif"')
    help = 'Index format: n (unpadded)'


class LifeOfConvenience(BasicScraper):
    latestUrl = 'http://comic.idle-me.com/'
    imageUrl = 'http://comic.idle-me.com/?strip_id=%s'
    imageSearch = compile(r'<img src="(comics/\d{6}\..+?)"')
    prevSearch = compile(r'<a href="(\?strip_id=\d+)">Previous</a>')
    help = 'Index format: n (unpadded)'


class Lint(BasicScraper):
    latestUrl = 'http://www.purnicellin.com/lint/'
    imageUrl = 'http://www.purnicellin.com/lint/?p=%s'
    imageSearch = compile(r'(wordpress/wp-content/uploads/.+?)".+?></p')
    prevSearch = compile(r'/lint/(.+?)".+?Prev')
    help = 'Index format: nnn (format unknown)'


class LookingForGroup(BasicScraper):
    latestUrl = 'http://www.lfgcomic.com/page/latest'
    imageUrl = 'http://www.lfgcomic.com/page/%s'
    imageSearch = compile(r'<img src="(http://archive.lfgcomic.com/.+?)"')
    prevSearch = compile(r'<a href="(/page/.+?)">\r\n.+?Previous')
    help = 'Index format: nnn'


class Loserz(BasicScraper):
    latestUrl = 'http://loserz.scribblekid.org/'
    imageUrl = 'http://loserz.scribblekid.org/index.php?id=%s'
    imageSearch = compile(r"<img src=\'(comics/\d{8}\..+?)\' border=1>")
    prevSearch = compile(r"<a href=\'(index\.php\?id=\d+)\'><img src=\'elements/back.gif\' alt=\'Previous Comic\'")
    help = 'Index format: n (unpadded)'


class LittleGamers(BasicScraper):
    latestUrl = 'http://www.little-gamers.com/'
    imageUrl = 'http://www.little-gamers.com/index.php?id=%s'
    imageSearch = compile(r'<img src="(http://www.little-gamers.com/comics/\d+\..+?)"')
    prevSearch = compile(r'<a href="(index.php\?comicID=\d+?)">(?:Previous|PREVIOUS)</a>')
    help = 'Index format: n (unpadded)'

    def namer(cls, imageUrl, pageUrl):
        return '%d' % (int(imageUrl.split('/')[-1].split('.')[0]),)


# XXX: This comic no longer appears to be (easily) traversable.
#lethalDoses = BasicScraper(
#    name='LethalDoses',
#    latestUrl='http://www.lethaldoses.com/',
#    imageUrl='http://www.lethaldoses.com/view.php?date=%s',
#    imageSearch=compile(r'<img src="(comics/strip_\d{3}\..*?)"[^>]*>')
#    prevSearch=compile(r'<a href=[\'"](/?index2\.php\?strip_id=\d+)[\'"]><img.+?src=[\'"]\./images/nav_prev.gif[\'"]'),
#    help='Index format: yyyy-mm-dd',
#    namer=queryNamer('date', usePageUrl=True))

# XXX: not quite sure what's going on here, but there seem to be two comics at
#      this site now, not one
#laurasComics = BasicScraper(
#    name='LaurasComics',
#    latestUrl='http://www.laurascomics.com/',
#    imageUrl='http://www.laurascomics.com/index.php?comicid=%s',
#    imageSearch=compile(r'<img src=(/showcomic.php\?comicid=\d+)>', IGNORECASE),
#    prevSearch=compile(r'<a href="(index.php\?comicid=\d+)"><img src="/images/gprev.gif"', IGNORECASE),
#    help='Index format: n (unpadded)',
#    namer=queryNamer('comicid'))
