from re import compile, IGNORECASE

from dosage.helpers import BasicScraper, indirectStarter


class OctopusPie(BasicScraper):
    latestUrl = 'http://www.octopuspie.com/'
    imageUrl = 'http://www.octopuspie.com/index.php\?date=%s'
    imageSearch = compile(r'<img src="(strippy/.+?)"')
    prevSearch = compile(r'<a href="(index.php\?date=.+?)">Prev')
    help = 'Index format: yyyy-mm-dd'


class OddFish(BasicScraper):
    latestUrl = 'http://www.odd-fish.net/'
    imageUrl = 'http://www.odd-fish.net/index.php\?comic_id=%s'
    imageSearch = compile(r'"(http://homepage.ntlworld.com/p.blackman/comics/.+?)"')
    prevSearch = compile(r'First.+?"(index.php\?comic_id=.+?)".+?older')
    help = 'Index format: n (unpadded)'


class OhMyGods(BasicScraper):
    latestUrl = 'http://ohmygods.timerift.net/'
    imageUrl = 'http://ohmygods.timerift.net/strips/%s.php'
    imageSearch = compile(r'<\!-- \#BeginEditable "strip" --><img src="((?:strips/\d{4}/\d{2}/)?\d{2}\..+?)" width="\d+" height="\d+" border="\d+">')
    prevSearch = compile(r'<a href="((?:strips/\d{4}/\d{2}/)?\d{2}\.php)">previous')
    help = 'Index format: yyyy/mm/dd'


class OkayPants(BasicScraper):
    latestUrl = 'http://www.okaypants.com/comic.php'
    imageUrl = 'http://www.okaypants.com/comic.php?st=%s'
    imageSearch = compile(r'"(comic/.+?)"')
    prevSearch = compile(r'"(.+?)".+previous')
    help = 'Index format: unknown'


class OtenbaFiles(BasicScraper):
    latestUrl = 'http://www.otenba-files.com/main.html'
    imageUrl = 'http://www.otenba-files.com/%s'
    imageSearch = compile(r'<img src="(comics/.+?)"')
    prevSearch = compile(r'href="(\d+.\d+.html)"><img src="Buttons/prev')
    help = 'Index format: n.nn'


class OurHomePlanet(BasicScraper):
    latestUrl = 'http://gdk.gd-kun.net/'
    imageUrl = 'http://gdk.gd-kun.net/%s.html'
    imageSearch = compile(r'<img src="(pages/comic.+?)"')
    prevSearch = compile(r'coords="50,18,95,65".+?href="(.+?\.html)".+?alt=')
    help = 'Index format: n (unpadded)'


class OkCancel(BasicScraper):
    imageUrl = 'http://www.ok-cancel.com/comic/%s.html'
    imageSearch = compile(r'src="(http://www.ok-cancel.com/strips/okcancel\d{8}.gif)"', IGNORECASE)
    prevSearch = compile(r'<div class="previous"><a href="(http://www.ok-cancel.com/comic/\d{1,4}.html)">', IGNORECASE)
    starter = indirectStarter('http://www.ok-cancel.com/', prevSearch)
    help = 'Index format: yyyymmdd'
